/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.ListIntervalsCollection;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.AlfaLettersListLabelsDetectionAlgorithm1;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.AlfaLettersListLabelsDetectionAlgorithm2;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ArabicNumbersListLabelsDetectionAlgorithm;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.RomanNumbersListLabelsDetectionAlgorithm;

public class ListLabelsUtils {
    private static final Set<Character> labels = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('\u2022'), Character.valueOf('\u25cf'), Character.valueOf('\u2714'), Character.valueOf('\u2717'), Character.valueOf('\u2794'), Character.valueOf('\u27a2'), Character.valueOf('\ue00a'), Character.valueOf('\ue00c'), Character.valueOf('\uf076'), Character.valueOf('\u2588'), Character.valueOf('\u25a0'), Character.valueOf('\u2013'), Character.valueOf('\uf0b7'), Character.valueOf('\uf0a7'), Character.valueOf('\u25a1'), Character.valueOf('\uf0a1'), Character.valueOf('\u25aa'), Character.valueOf('\u25fc')));
    private static final Character o = Character.valueOf('o');

    public static boolean isListLabel(String value) {
        char label = value.charAt(0);
        return labels.contains(Character.valueOf(label)) || Character.isDigit(label) || ListLabelsUtils.isLetterLabel(value);
    }

    public static boolean isLetterLabel(String value) {
        boolean isFirstCharLetter = Character.isLetter(value.charAt(0));
        if (value.length() > 2) {
            return isFirstCharLetter && !Character.isLetter(value.charAt(1));
        }
        return isFirstCharLetter;
    }

    public static boolean isListLabels(List<String> listLabels) {
        if (listLabels.size() < 2) {
            return false;
        }
        if (listLabels.get(0).trim().isEmpty()) {
            return false;
        }
        ArrayList<String> labels = new ArrayList<String>(listLabels.size());
        for (String listLabel : listLabels) {
            String label = listLabel.trim();
            if (label.isEmpty()) continue;
            labels.add(label);
        }
        if (labels.size() < 2) {
            return false;
        }
        if (ListLabelsUtils.isEqualsLabels(labels)) {
            return ((String)labels.get(0)).length() == 1;
        }
        int commonStartLength = ListLabelsUtils.getCommonStartLength((String)labels.get(0), (String)labels.get(1));
        int commonEndLength = ListLabelsUtils.getCommonEndLength((String)labels.get(0), (String)labels.get(1));
        int minLength = Math.min(((String)labels.get(0)).length(), ((String)labels.get(1)).length());
        for (int i = 2; i < labels.size(); ++i) {
            commonStartLength = ListLabelsUtils.getCommonStartLength((String)labels.get(0), (String)labels.get(i), commonStartLength);
            commonEndLength = ListLabelsUtils.getCommonEndLength((String)labels.get(0), (String)labels.get(i), commonEndLength);
            if (minLength <= ((String)labels.get(i)).length()) continue;
            minLength = ((String)labels.get(i)).length();
        }
        if (commonStartLength + commonEndLength > minLength) {
            int temp = commonEndLength;
            commonEndLength = minLength - commonStartLength;
            commonStartLength = minLength - temp;
        }
        return new RomanNumbersListLabelsDetectionAlgorithm().isListLabels(labels, commonStartLength, commonEndLength) || new ArabicNumbersListLabelsDetectionAlgorithm().isListLabels(labels, commonStartLength, commonEndLength) || new AlfaLettersListLabelsDetectionAlgorithm1().isListLabels(labels, commonStartLength, commonEndLength) || new AlfaLettersListLabelsDetectionAlgorithm2().isListLabels(labels, commonStartLength, commonEndLength);
    }

    private static boolean isEqualsLabels(List<String> labels) {
        for (int i = 1; i < labels.size(); ++i) {
            if (labels.get(0).equals(labels.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int getCommonStartLength(String s1, String s2) {
        return ListLabelsUtils.getCommonStartLength(s1, s2, Math.min(s1.length(), s2.length()));
    }

    private static int getCommonStartLength(String s1, String s2, int length) {
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return length;
    }

    private static int getCommonEndLength(String s1, String s2) {
        return ListLabelsUtils.getCommonEndLength(s1, s2, Math.min(s1.length(), s2.length()));
    }

    private static int getCommonEndLength(String s1, String s2, int length) {
        for (int i = 1; i <= length; ++i) {
            if (s1.charAt(s1.length() - i) == s2.charAt(s2.length() - i)) continue;
            return i - 1;
        }
        return length;
    }

    public static Set<ListInterval> getImageListItemsIntervals(List<? extends ListItemInfo> itemsInfo) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        ListInterval interval = new ListInterval();
        interval.getListItemsInfos().add(itemsInfo.get(0));
        InfoChunk image = itemsInfo.get(0).getListItemValue();
        for (int i = 1; i < itemsInfo.size(); ++i) {
            InfoChunk currentImage = itemsInfo.get(i).getListItemValue();
            if (!NodeUtils.areCloseNumbers(image.getBoundingBox().getWidth(), currentImage.getBoundingBox().getWidth()) || !NodeUtils.areCloseNumbers(image.getBoundingBox().getHeight(), currentImage.getBoundingBox().getHeight())) {
                if (SemanticType.LIST == itemsInfo.get(i).getSemanticType()) {
                    interval.getListsIndexes().add(itemsInfo.get(i).getIndex());
                    continue;
                }
                if (interval.getNumberOfListItems() > 1) {
                    listIntervals.add(interval);
                }
                image = itemsInfo.get(i).getListItemValue();
                interval = new ListInterval();
                interval.getListItemsInfos().add(itemsInfo.get(i));
                continue;
            }
            interval.getListItemsInfos().add(itemsInfo.get(i));
        }
        if (interval.getNumberOfListItems() > 1) {
            listIntervals.add(interval);
        }
        return listIntervals;
    }

    public static Set<ListInterval> getListItemsIntervals(List<ListItemTextInfo> itemsInfo) {
        ListIntervalsCollection listIntervals = new ListIntervalsCollection(ListLabelsUtils.getItemsWithEqualsLabels(itemsInfo));
        listIntervals.putAll(new AlfaLettersListLabelsDetectionAlgorithm1().getItemsIntervals(itemsInfo));
        listIntervals.putAll(new AlfaLettersListLabelsDetectionAlgorithm2().getItemsIntervals(itemsInfo));
        listIntervals.putAll(new RomanNumbersListLabelsDetectionAlgorithm().getItemsIntervals(itemsInfo));
        listIntervals.putAll(new ArabicNumbersListLabelsDetectionAlgorithm().getItemsIntervals(itemsInfo));
        return listIntervals.getSet();
    }

    public static Set<ListInterval> getItemsWithEqualsLabels(List<ListItemTextInfo> itemsInfo) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        Character firstChar = null;
        Character secondChar = null;
        ListInterval interval = new ListInterval();
        for (ListItemTextInfo info : itemsInfo) {
            boolean badListItem;
            boolean bl = badListItem = info.getListItem().length() == 1 && info.hasOneLine();
            if (!Objects.equals(Character.valueOf(info.getListItem().charAt(0)), firstChar) || badListItem) {
                if (SemanticType.LIST == info.getSemanticType()) {
                    interval.getListsIndexes().add(info.getIndex());
                    continue;
                }
                if (interval.getNumberOfListItems() > 1 && ListLabelsUtils.checkForSuitableLabel(firstChar, secondChar)) {
                    listIntervals.add(interval);
                }
                if (badListItem) {
                    firstChar = null;
                    secondChar = null;
                } else {
                    firstChar = Character.valueOf(info.getListItem().charAt(0));
                    secondChar = Character.valueOf(info.getListItem().length() > 1 ? info.getListItem().charAt(1) : (char)' ');
                }
                interval = new ListInterval();
            }
            interval.getListItemsInfos().add(info);
        }
        if (interval.getNumberOfListItems() > 1 && ListLabelsUtils.checkForSuitableLabel(firstChar, secondChar)) {
            listIntervals.add(interval);
        }
        return listIntervals;
    }

    private static boolean checkForSuitableLabel(Character firstChar, Character secondChar) {
        return labels.contains(firstChar) || o.equals(firstChar) && !Character.isLetter(secondChar.charValue());
    }
}

