/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticList;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.ListIntervalsCollection;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.HeadingUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class ListUtils {
    public static final double LIST_LABEL_HEIGHT_EPSILON = 2.5;
    public static final double ONE_COLUMN_EPSILON = 0.33;
    private static final Set<SemanticType> listSemanticTypes = new HashSet<SemanticType>(Arrays.asList(SemanticType.LIST, SemanticType.LIST_ITEM, SemanticType.LIST_LABEL, SemanticType.LIST_BODY));

    public static boolean isDetectedListNode(INode node) {
        return listSemanticTypes.contains((Object)node.getSemanticType());
    }

    public static boolean isInitialListNode(INode node) {
        return listSemanticTypes.contains((Object)node.getInitialSemanticType());
    }

    public static boolean isList(Table table) {
        ArrayList<String> textLabels = new ArrayList<String>(table.getRows().size());
        ArrayList<BoundingBox> imageLabels = new ArrayList<BoundingBox>(table.getRows().size());
        for (TableRow row : table.getRows()) {
            List<TableCell> cells = row.getCells();
            if (cells.size() != 2) {
                return false;
            }
            TableCell cell = cells.get(0);
            if (cell.isTextCell()) {
                textLabels.add(cell.getString());
                continue;
            }
            if (cell.getContent().size() == 1 && cell.getContent().get(0).getType() == TableToken.TableTokenType.IMAGE) {
                imageLabels.add(cell.getContent().get(0).getBoundingBox());
                continue;
            }
            return false;
        }
        if (!imageLabels.isEmpty() && !textLabels.isEmpty()) {
            return false;
        }
        return imageLabels.isEmpty() ? ListLabelsUtils.isListLabels(textLabels, 1) : ListUtils.isListImageLabels(imageLabels);
    }

    public static boolean isListImageLabels(List<BoundingBox> listLabels) {
        if (listLabels.size() < 2) {
            return false;
        }
        BoundingBox firstLabel = listLabels.get(0);
        double firstLabelHeight = firstLabel.getHeight();
        for (int i = 1; i < listLabels.size(); ++i) {
            if (NodeUtils.areCloseNumbers(listLabels.get(i).getLeftX(), listLabels.get(0).getLeftX()) && NodeUtils.areCloseNumbers(listLabels.get(i).getRightX(), listLabels.get(0).getRightX()) && NodeUtils.areCloseNumbers(listLabels.get(i).getHeight(), firstLabelHeight)) continue;
            return false;
        }
        return true;
    }

    public static void updateTreeWithRecognizedLists(INode node, Set<ListInterval> listIntervals) {
        for (ListInterval listInterval : listIntervals) {
            ListUtils.updateTreeWithRecognizedList(node, listInterval);
        }
    }

    public static void updateTreeWithRecognizedList(INode node, ListInterval listInterval) {
        double probability;
        Long listId = StaticContainers.getNextID();
        List<INode> children = node.getChildren();
        for (ListItemInfo info : listInterval.getListItemsInfos()) {
            INode child = children.get(info.getIndex());
            if (child.getSemanticType() == SemanticType.TABLE_OF_CONTENT_ITEM || child.getSemanticType() == SemanticType.TABLE_OF_CONTENT) continue;
            ListUtils.updateTreeWithRecognizedListItem(child, listId);
        }
        if (node.getRecognizedStructureId() == null && (probability = (double)listInterval.getNumberOfListItemsAndLists() / (double)node.getChildren().size()) >= 0.75) {
            INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticList((SemanticTextNode)accumulatedNode, listInterval), probability, SemanticType.LIST);
            node.setRecognizedStructureId(listId);
        }
    }

    public static void updateTreeWithRecognizedListItem(INode item, Long listId) {
        item.setSemanticType(SemanticType.LIST_ITEM);
        item.setCorrectSemanticScore(1.0);
        item.setRecognizedStructureId(listId);
        List<INode> children = item.getChildren();
        if (children.size() == 1) {
            INode child = children.get(0);
            child.setSemanticType(SemanticType.LIST_BODY);
            child.setCorrectSemanticScore(1.0);
            child.setRecognizedStructureId(listId);
        } else if (children.size() > 1) {
            INode child = children.get(0);
            child.setSemanticType(SemanticType.LIST_LABEL);
            child.setRecognizedStructureId(listId);
            for (int i = 1; i < children.size(); ++i) {
                child = children.get(i);
                child.setSemanticType(SemanticType.LIST_BODY);
                child.setCorrectSemanticScore(1.0);
                child.setRecognizedStructureId(listId);
            }
        }
    }

    public static Set<ListInterval> getChildrenListIntervals(Set<ListInterval> listIntervals, List<INode> children) {
        ListIntervalsCollection listIntervalsCollection = new ListIntervalsCollection();
        for (ListInterval listInterval : listIntervals) {
            ListUtils.checkChildrenListInterval(listIntervalsCollection, listInterval, children);
        }
        return listIntervalsCollection.getSet();
    }

    public static void checkChildrenListInterval(ListIntervalsCollection listIntervalsCollection, ListInterval listInterval, List<INode> children) {
        ArrayList<ListItemInfo> listItemInfos = new ArrayList<ListItemInfo>();
        listItemInfos.add(listInterval.getListItemsInfos().get(0));
        INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(children.get(listInterval.getListItemsStart()));
        double right = accumulatedChild.getRightX();
        int numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
        ListItemInfo previousItemInfo = listInterval.getListItemsInfos().get(0);
        for (ListItemInfo info : listInterval.getListItemsInfos().subList(1, listInterval.getNumberOfListItems())) {
            int lastChildNumberOfColumns = 0;
            if (accumulatedChild instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)accumulatedChild;
                if (textNode.getColumnsNumber() > 1) {
                    right = textNode.getPenultColumn().getRightX();
                }
                lastChildNumberOfColumns = Math.max(textNode.getColumnsNumber() - 2, 0);
            }
            InfoChunk line1 = previousItemInfo.getListItemValue();
            InfoChunk line2 = info.getListItemValue();
            accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(children.get(info.getIndex()));
            if (line1.getPageNumber() + 1 < line2.getPageNumber() || ListUtils.isContainsHeading(children.get(previousItemInfo.getIndex())) || children.get(previousItemInfo.getIndex()).getInitialSemanticType() == SemanticType.NOTE) {
                ListUtils.updateListIntervalCollection(listIntervalsCollection, listInterval, listItemInfos, numberOfColumns);
                right = -1.7976931348623157E308;
                numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                listItemInfos = new ArrayList();
                listItemInfos.add(info);
                previousItemInfo = info;
                continue;
            }
            if (Objects.equals(line1.getPageNumber(), line2.getPageNumber())) {
                if (!ListUtils.isOneColumn(line1, line2) && right >= accumulatedChild.getLeftX()) {
                    ListUtils.updateListIntervalCollection(listIntervalsCollection, listInterval, listItemInfos, numberOfColumns);
                    right = -1.7976931348623157E308;
                    numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                    listItemInfos = new ArrayList();
                }
                if (!ListUtils.isOneColumn(line1, line2)) {
                    if (StaticContainers.isDataLoader()) {
                        ListUtils.updateListIntervalCollection(listIntervalsCollection, listInterval, listItemInfos, numberOfColumns);
                        right = -1.7976931348623157E308;
                        numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                        listItemInfos = new ArrayList();
                        listItemInfos.add(info);
                        previousItemInfo = info;
                        continue;
                    }
                    numberOfColumns += lastChildNumberOfColumns + 1;
                }
                listItemInfos.add(info);
                right = Math.max(right, accumulatedChild.getRightX());
            } else {
                if (StaticContainers.isDataLoader()) {
                    ListUtils.updateListIntervalCollection(listIntervalsCollection, listInterval, listItemInfos, numberOfColumns);
                    right = -1.7976931348623157E308;
                    numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                    listItemInfos = new ArrayList();
                } else {
                    ++numberOfColumns;
                    right = accumulatedChild.getRightX();
                }
                listItemInfos.add(info);
            }
            previousItemInfo = info;
        }
        ListUtils.updateListIntervalCollection(listIntervalsCollection, listInterval, listItemInfos, numberOfColumns);
    }

    private static boolean isContainsHeading(INode node) {
        INode currentNode = node;
        block0: while (currentNode.getPageNumber() != null) {
            if (HeadingUtils.isDetectedHeadingNode(currentNode) && currentNode.getCorrectSemanticScore() >= 0.9) {
                return true;
            }
            if (currentNode.getChildren().isEmpty()) {
                return false;
            }
            for (INode child : currentNode.getChildren()) {
                if (child.getPageNumber() == null) continue;
                currentNode = child;
                continue block0;
            }
        }
        return false;
    }

    private static void updateListIntervalCollection(ListIntervalsCollection listIntervalsCollection, ListInterval listInterval, List<ListItemInfo> listItemsInfos, int numberOfColumns) {
        if (listItemsInfos.size() > 1) {
            ListInterval newListInterval = new ListInterval(listItemsInfos, listInterval.getListsIndexesContainedInListItemsIndexes(listItemsInfos), numberOfColumns);
            newListInterval.setNumberingStyle(listInterval.getNumberingStyle());
            listIntervalsCollection.put(newListInterval);
        }
    }

    private static int getInitialListColumnsNumber(INode node) {
        return node instanceof SemanticTextNode ? Math.max(((SemanticTextNode)node).getColumnsNumber() - 1, 1) : 1;
    }

    private static boolean isOneColumn(InfoChunk line1, InfoChunk line2) {
        return NodeUtils.areCloseNumbers(line1.getLeftX(), line2.getLeftX(), 0.33 * line1.getBoundingBox().getHeight());
    }
}

