/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class TextChunkUtils {
    public static final double WHITE_SPACE_FACTOR = 0.25;
    public static final double NEIGHBORS_EPSILON = 0.2;
    public static final double BASELINE_DIFFERENCE_EPSILON = 0.01;
    public static final double TEXT_CHUNK_SPACE_RATIO = 170.0;
    public static final double TEXT_LINE_SPACE_RATIO = 0.17;
    public static final double SPLIT_THRESHOLD_FACTOR = 0.77;
    public static final Set<Character> HYPHENATION_SIGNS = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('\u2014'), Character.valueOf('\u00ad')));

    public static boolean isSpaceChunk(TextChunk chunk) {
        for (char symbol : chunk.getValue().toCharArray()) {
            if (Character.isSpaceChar(symbol)) continue;
            return false;
        }
        return true;
    }

    public static void formatLineEnd(StringBuilder stringBuilder) {
        if (StaticContainers.isKeepLineBreaks()) {
            stringBuilder.append("\n");
        } else if (HYPHENATION_SIGNS.contains(Character.valueOf(stringBuilder.charAt(stringBuilder.length() - 1)))) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else {
            stringBuilder.append(" ");
        }
    }

    public static boolean isWhiteSpaceChunk(TextChunk chunk) {
        for (char symbol : chunk.getValue().toCharArray()) {
            if (TextChunkUtils.isWhiteSpaceChar(symbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainsWhiteSpaceChar(String string) {
        for (char symbol : string.toCharArray()) {
            if (!TextChunkUtils.isWhiteSpaceChar(symbol)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhiteSpaceChar(char symbol) {
        return Character.isWhitespace(symbol) || symbol == '\u00a0' || symbol == '\u2007' || symbol == '\u202f';
    }

    public static boolean areTextChunksHaveSameStyle(TextChunk firstTextChunk, TextChunk secondTextChunk) {
        return Objects.equals(firstTextChunk.getFontName(), secondTextChunk.getFontName()) && NodeUtils.areCloseNumbers(firstTextChunk.getFontWeight(), secondTextChunk.getFontWeight()) && NodeUtils.areCloseNumbers(firstTextChunk.getItalicAngle(), secondTextChunk.getItalicAngle()) && Arrays.equals(firstTextChunk.getFontColor(), secondTextChunk.getFontColor()) && NodeUtils.areCloseNumbers(firstTextChunk.getFontSize(), secondTextChunk.getFontSize()) && NodeUtils.areCloseNumbers(firstTextChunk.getSlantDegree(), secondTextChunk.getSlantDegree());
    }

    public static boolean areTextChunksHaveSameBaseLine(TextChunk firstTextChunk, TextChunk secondTextChunk) {
        return NodeUtils.areCloseNumbers(firstTextChunk.getBaseLine(), secondTextChunk.getBaseLine(), 0.01 * firstTextChunk.getBoundingBox().getHeight());
    }

    public static TextChunk unionTextChunks(TextChunk firstTextChunk, TextChunk secondTextChunk) {
        TextChunk newTextChunk = new TextChunk(firstTextChunk);
        newTextChunk.setValue(firstTextChunk.getValue() + secondTextChunk.getValue());
        newTextChunk.getBoundingBox().union(secondTextChunk.getBoundingBox());
        newTextChunk.getSymbolEnds().addAll(secondTextChunk.getSymbolEnds().subList(1, secondTextChunk.getSymbolEnds().size()));
        return newTextChunk;
    }

    public static boolean areNeighborsTextChunks(TextChunk firstTextChunk, TextChunk secondTextChunk) {
        return NodeUtils.areCloseNumbers(firstTextChunk.getTextEnd(), secondTextChunk.getTextStart(), 0.2 * firstTextChunk.getBoundingBox().getHeight());
    }

    public static List<TextChunk> splitTextChunkByWhiteSpaces(TextChunk originalChunk) {
        List<Integer> partsBoundaries = TextChunkUtils.findWideWhiteSpaces(originalChunk);
        if (partsBoundaries.size() <= 2) {
            ArrayList<TextChunk> result = new ArrayList<TextChunk>();
            result.add(originalChunk);
            return result;
        }
        return TextChunkUtils.createPartsFromBoundaries(originalChunk, partsBoundaries);
    }

    private static List<Integer> findWideWhiteSpaces(TextChunk chunk) {
        double threshold = chunk.getFontSize() * 0.77;
        ArrayList<Integer> boundaries = new ArrayList<Integer>();
        boundaries.add(-1);
        String text = chunk.getValue();
        for (int i = 1; i < text.length(); ++i) {
            Double width;
            if (!TextChunkUtils.isWhiteSpaceChar(text.charAt(i)) || (width = chunk.getSymbolWidth(i)) == null || !(width > threshold)) continue;
            boundaries.add(i);
        }
        boundaries.add(text.length());
        return boundaries;
    }

    private static List<TextChunk> createPartsFromBoundaries(TextChunk originalChunk, List<Integer> boundaries) {
        ArrayList<TextChunk> parts = new ArrayList<TextChunk>();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            int end;
            int start = boundaries.get(i);
            TextChunk part = ChunksMergeUtils.getTrimTextChunk(TextChunk.getTextChunk(originalChunk, start + 1, end = boundaries.get(i + 1).intValue()));
            if (part == null || part.isWhiteSpaceChunk()) continue;
            parts.add(part);
        }
        return parts;
    }
}

