/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSALinkAnnotation;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAAnnotation;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDPage;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class GFSAAnnotation
extends GenericModelObject
implements SAAnnotation {
    public static final String ANNOTATION_TYPE = "SAAnnotation";
    public static final String LINK = "Link";
    private final PDAnnotation annot;
    private final PDPage page;
    private String textValue;

    public GFSAAnnotation(PDAnnotation annot, PDPage page) {
        this(annot, page, ANNOTATION_TYPE);
    }

    public GFSAAnnotation(PDAnnotation annot, PDPage page, String type) {
        super(type);
        this.page = page;
        this.annot = annot;
    }

    public String gettextValue() {
        if (this.textValue == null) {
            this.textValue = this.findTextValue();
        }
        return this.textValue;
    }

    private String findTextValue() {
        double[] rect = this.annot.getRect();
        if (rect != null) {
            List<IChunk> chunks = StaticStorages.getChunks().get(this.page.getObject().getKey(), new BoundingBox(this.page.getPageNumber(), rect));
            return chunks.stream().filter(iChunk -> iChunk instanceof TextChunk).map(chunk -> ((TextChunk)chunk).getValue()).reduce((s1, s2) -> s1 + s2).orElse("").trim();
        }
        return "";
    }

    public Boolean gethasLinkValue() {
        try {
            new URL(this.gettextValue());
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static GFSAAnnotation createAnnot(PDAnnotation annot, PDPage page) {
        String subtypeString;
        ASAtom subtype = annot.getSubtype();
        if (subtype == null) {
            return new GFSAAnnotation(annot, page);
        }
        switch (subtypeString = subtype.getValue()) {
            case "Link": {
                return new GFSALinkAnnotation(annot, page);
            }
        }
        return new GFSAAnnotation(annot, page);
    }

    public Boolean getisOutsideCropBox() {
        double[] cropBox = this.page.getCropBox();
        double[] rectangle = this.annot.getRect();
        if (rectangle != null && rectangle.length >= 4) {
            return cropBox[1] >= rectangle[3] || cropBox[0] >= rectangle[2] || cropBox[3] <= rectangle[1] || cropBox[2] <= rectangle[0];
        }
        return null;
    }

    public String getContents() {
        return this.annot.getContents();
    }

    public Long getF() {
        return this.annot.getF();
    }
}

