/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.ExitCode;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jhove {
    private static final String NAME = "Jhove";
    private static final Logger LOGGER = Logger.getLogger(Jhove.class.getCanonicalName());

    private Jhove() {
        throw new AssertionError((Object)"Should never enter private constructor");
    }

    public static void main(String[] args) {
        String version = System.getProperty("java.vm.version");
        if (version.compareTo("1.8.0") < 0) {
            LOGGER.log(Level.SEVERE, "Java 1.8 or higher is required");
            System.exit(ExitCode.INCOMPATIBLE_VM.getReturnCode());
        }
        try {
            OutputHandler handler;
            OutputHandler about;
            Module module;
            App app = App.newAppWithName(NAME);
            String configFile = JhoveBase.getConfigFileFromProperties();
            String saxClass = JhoveBase.getSaxClassFromProperties();
            boolean quoted = false;
            for (int i = 0; i < args.length; ++i) {
                if (quoted) {
                    int len = args[i].length();
                    if (args[i].charAt(len - 1) != '\"') continue;
                    quoted = false;
                    continue;
                }
                if ("-c".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    configFile = args[++i];
                    continue;
                }
                if ("-x".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    saxClass = args[++i];
                    continue;
                }
                if (args[i].charAt(0) != '\"') continue;
                quoted = true;
            }
            String encoding = null;
            String tempDir = null;
            int bufferSize = -1;
            String moduleName = null;
            String handlerName = null;
            String aboutHandler = null;
            String logLevel = null;
            String outputFile = null;
            boolean checksum = false;
            boolean showRaw = false;
            boolean signature = false;
            ArrayList<String> list = new ArrayList<String>();
            quoted = false;
            StringBuilder filename = null;
            for (int i = 0; i < args.length; ++i) {
                if (quoted) {
                    filename.append(" ");
                    int len = args[i].length();
                    if (args[i].charAt(len - 1) == '\"') {
                        filename.append(args[i].substring(0, len - 1));
                        list.add(filename.toString());
                        quoted = false;
                        continue;
                    }
                    filename.append(args[i]);
                    continue;
                }
                if ("-c".equals(args[i])) {
                    ++i;
                    continue;
                }
                if ("-m".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    moduleName = args[++i];
                    continue;
                }
                if ("-p".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    String len = args[++i];
                    continue;
                }
                if ("-h".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    handlerName = args[++i];
                    continue;
                }
                if ("-P".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    String len = args[++i];
                    continue;
                }
                if ("-e".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    encoding = args[++i];
                    continue;
                }
                if ("-H".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    aboutHandler = args[++i];
                    continue;
                }
                if ("-l".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    logLevel = args[++i];
                    continue;
                }
                if ("-o".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    outputFile = args[++i];
                    continue;
                }
                if ("-x".equals(args[i])) {
                    ++i;
                    continue;
                }
                if ("-t".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    tempDir = args[++i];
                    continue;
                }
                if ("-b".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    try {
                        bufferSize = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Invalid buffer size, using default.");
                    }
                    continue;
                }
                if ("-k".equals(args[i])) {
                    checksum = true;
                    continue;
                }
                if ("-r".equals(args[i])) {
                    showRaw = true;
                    continue;
                }
                if ("-s".equals(args[i])) {
                    signature = true;
                    continue;
                }
                if (args[i].charAt(0) == '-') continue;
                if (args[i].charAt(0) == '\"') {
                    filename = new StringBuilder();
                    filename.append(args[i].substring(1));
                    quoted = true;
                    continue;
                }
                list.add(args[i]);
            }
            if (quoted) {
                list.add(filename.toString());
            }
            JhoveBase je = new JhoveBase();
            if (logLevel != null) {
                je.setLogLevel(logLevel);
            }
            je.init(configFile, saxClass);
            if (encoding == null) {
                encoding = je.getEncoding();
            }
            if (tempDir == null) {
                tempDir = je.getTempDirectory();
            }
            if (bufferSize < 0) {
                bufferSize = je.getBufferSize();
            }
            if ((module = je.getModule(moduleName)) == null && moduleName != null) {
                LOGGER.log(Level.SEVERE, "Module '" + moduleName + "' not found");
                System.exit(ExitCode.ERROR.getReturnCode());
            }
            if ((about = je.getHandler(aboutHandler)) == null && aboutHandler != null) {
                LOGGER.log(Level.SEVERE, "Handler '" + aboutHandler + "' not found");
                System.exit(ExitCode.ERROR.getReturnCode());
            }
            if ((handler = je.getHandler(handlerName)) == null && handlerName != null) {
                LOGGER.log(Level.SEVERE, "Handler '" + handlerName + "' not found");
                System.exit(ExitCode.ERROR.getReturnCode());
            }
            String[] dirFileOrUri = null;
            int len = list.size();
            if (len > 0) {
                dirFileOrUri = new String[len];
                for (int i = 0; i < len; ++i) {
                    dirFileOrUri[i] = (String)list.get(i);
                }
            }
            je.setEncoding(encoding);
            je.setTempDirectory(tempDir);
            je.setBufferSize(bufferSize);
            je.setChecksumFlag(checksum);
            je.setShowRawFlag(showRaw);
            je.setSignatureFlag(signature);
            je.dispatch(app, module, about, handler, outputFile, dirFileOrUri);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
            e.printStackTrace(System.err);
            System.exit(ExitCode.ERROR.getReturnCode());
        }
    }
}

