/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.Html4DocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4StrictDocDesc
extends Html4DocDesc {
    protected Html4StrictDocDesc() {
    }

    protected static void classInit4(Map stSupportedElements) {
        HtmlTagDesc td;
        String name;
        int i;
        Html4DocDesc.classInit4(stSupportedElements);
        fontMarkup = new String[]{"tt", "i", "b", "big", "small"};
        listMarkup = new String[]{"ul", "ol"};
        specialMarkup = new String[]{"a", "img", "object", "br", "script", "map", "q", "sub", "sup", "span", "bdo"};
        inlineContent = new ArrayList(35);
        Html4StrictDocDesc.addStringsToList(fontMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(phraseMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(specialMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(formMarkup, inlineContent);
        inlineContent.add(HtmlSpecialToken.PCDATA);
        blockContent = new ArrayList(20);
        Html4StrictDocDesc.addStringsToList(headings, blockContent);
        Html4StrictDocDesc.addStringsToList(listMarkup, blockContent);
        String[] blockMisc = new String[]{"p", "pre", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address"};
        Html4StrictDocDesc.addStringsToList(blockMisc, blockContent);
        flowContent = new ArrayList(30);
        flowContent.addAll(blockContent);
        flowContent.addAll(inlineContent);
        bodyContent = new ArrayList(blockContent.size() + 3);
        bodyContent.addAll(blockContent);
        bodyContent.add("script");
        bodyContent.add("ins");
        bodyContent.add("del");
        listContent = new ArrayList(1);
        listContent.add("li");
        for (i = 0; i < fontMarkup.length; ++i) {
            name = fontMarkup[i];
            td = new HtmlTagDesc(name, true, true, inlineContent, bigAttrs);
            stSupportedElements.put(name, td);
        }
        for (i = 0; i < phraseMarkup.length; ++i) {
            name = phraseMarkup[i];
            td = new HtmlTagDesc(name, true, true, inlineContent, bigAttrs);
            stSupportedElements.put(name, td);
        }
        thtdAtts = new ArrayList(bigAttrs.size() + 7);
        thtdAtts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "abbr");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "axis");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "headers");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "scope");
        thtdAtts.add(halignAtt);
        thtdAtts.add(valignAtt);
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "rowspan");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "colspan");
    }

    protected static void addAElement(Map stSupportedElements) {
        String name = "a";
        ArrayList atts = new ArrayList(bigAttrs.size() + 14);
        atts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "type");
        Html4StrictDocDesc.addSimpleAttribute(atts, "name");
        Html4StrictDocDesc.addSimpleAttribute(atts, "href");
        Html4StrictDocDesc.addSimpleAttribute(atts, "hreflang");
        Html4StrictDocDesc.addSimpleAttribute(atts, "rel");
        Html4StrictDocDesc.addSimpleAttribute(atts, "rev");
        Html4StrictDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(atts, "shape");
        Html4StrictDocDesc.addSimpleAttribute(atts, "rect");
        Html4StrictDocDesc.addSimpleAttribute(atts, "coords");
        Html4StrictDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onblur");
        ArrayList content = new ArrayList(inlineContent.size());
        content.addAll(inlineContent);
        content.remove("a");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addAddressElement(Map stSupportedElements) {
        String name = "address";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, inlineContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addAreaElement(Map stSupportedElements, HtmlAttributeDesc shapeAtt) {
        String name = "area";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(5);
        atts.add(shapeAtt);
        Html4StrictDocDesc.addSimpleAttribute(atts, "coords");
        Html4StrictDocDesc.addSimpleAttribute(atts, "href");
        atts.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        atts.add(new HtmlAttributeDesc("alt", null, 1));
        Html4StrictDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onblur");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBaseElement(Map stSupportedElements) {
        String name = "base";
        ArrayList atts = new ArrayList(1);
        Html4StrictDocDesc.addRequiredAttribute(atts, "href");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBlockquoteElement(Map stSupportedElements) {
        String name = "blockquote";
        ArrayList<String> content = new ArrayList<String>(blockContent.size() + 1);
        content.addAll(blockContent);
        content.add("script");
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "cite");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBrElement(Map stSupportedElements, List coreAttrs) {
        String name = "br";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, coreAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addButtonElement(Map stSupportedElements) {
        ArrayList<String> content = new ArrayList<String>(formMarkup.length + 3);
        Html4StrictDocDesc.addStringsToList(formMarkup, content);
        content.add("form");
        content.add("fieldset");
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        atts.addAll(biggerAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "name");
        Html4StrictDocDesc.addSimpleAttribute(atts, "value");
        atts.add(new HtmlAttributeDesc("type", new String[]{"button", "submit", "reset"}, 5));
        Html4StrictDocDesc.addSelfAttribute(atts, "disabled");
        Html4StrictDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(atts, "onblur");
    }

    protected static void addCaptionElement(Map stSupportedElements, List inlineContent, HtmlAttributeDesc valignAtt) {
        String name = "caption";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, inlineContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addDivElement(Map stSupportedElements) {
        String name = "div";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, flowContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addDlElement(Map stSupportedElements) {
        String name = "dl";
        ArrayList dlContent = new ArrayList(2);
        Html4StrictDocDesc.addStringsToList(new String[]{"dt", "dd"}, dlContent);
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, dlContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addHeadElement(Map stSupportedElements) {
        String name = "head";
        String[] headMisc = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> headContent = new ArrayList<String>(7);
        headContent.add("title");
        headContent.add("base");
        headContent.add("script");
        headContent.add("style");
        headContent.add("meta");
        headContent.add("link");
        headContent.add("object");
        HtmlTagDesc td = new HtmlTagDesc(name, false, false, headContent, null);
        stSupportedElements.put(name, td);
        Html4StrictDocDesc.addStringsToList(headMisc, headContent);
    }

    protected static void addLegendElement(Map stSupportedElements) {
        String name = "label";
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "accesskey");
        HtmlTagDesc td = new HtmlTagDesc("label", true, true, inlineContent, atts);
        stSupportedElements.put("label", td);
    }

    protected static void addLiElement(Map stSupportedElements) {
        String name = "li";
        HtmlTagDesc td = new HtmlTagDesc("li", true, false, flowContent, bigAttrs);
        stSupportedElements.put("li", td);
    }

    protected static void addLinkElement(Map stSupportedElements) {
        String name = "link";
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "charset");
        Html4StrictDocDesc.addSimpleAttribute(atts, "href");
        Html4StrictDocDesc.addSimpleAttribute(atts, "hreflang");
        Html4StrictDocDesc.addSimpleAttribute(atts, "type");
        Html4StrictDocDesc.addSimpleAttribute(atts, "rel");
        Html4StrictDocDesc.addSimpleAttribute(atts, "rev");
        Html4StrictDocDesc.addSimpleAttribute(atts, "media");
        HtmlTagDesc td = new HtmlTagDesc("link", true, false, null, atts);
        stSupportedElements.put("link", td);
    }

    protected static void addNoscriptElement(Map stSupportedElements) {
        String name = "noscript";
        HtmlTagDesc td = new HtmlTagDesc("noscript", true, false, blockContent, bigAttrs);
        stSupportedElements.put("noscript", td);
    }

    protected static void addObjectElement(Map stSupportedElements) {
        String name = "object";
        ArrayList atts = new ArrayList(biggerAttrs.size() + 13);
        atts.addAll(biggerAttrs);
        Html4StrictDocDesc.addSelfAttribute(atts, "declare");
        Html4StrictDocDesc.addSimpleAttribute(atts, "classid");
        Html4StrictDocDesc.addSimpleAttribute(atts, "codebase");
        Html4StrictDocDesc.addSimpleAttribute(atts, "data");
        Html4StrictDocDesc.addSimpleAttribute(atts, "type");
        Html4StrictDocDesc.addSimpleAttribute(atts, "codetype");
        Html4StrictDocDesc.addSimpleAttribute(atts, "archive");
        Html4StrictDocDesc.addSimpleAttribute(atts, "standby");
        Html4StrictDocDesc.addSimpleAttribute(atts, "height");
        Html4StrictDocDesc.addSimpleAttribute(atts, "width");
        Html4StrictDocDesc.addSimpleAttribute(atts, "usemap");
        Html4StrictDocDesc.addSimpleAttribute(atts, "name");
        Html4StrictDocDesc.addSimpleAttribute(atts, "tabindex");
    }

    protected static void addOlElement(Map stSupportedElements) {
        String name = "ol";
        HtmlTagDesc td = new HtmlTagDesc("ol", true, true, listContent, bigAttrs);
        stSupportedElements.put("ol", td);
    }

    protected static void addPElement(Map stSupportedElements) {
        String name = "p";
        HtmlTagDesc td = new HtmlTagDesc("p", true, false, inlineContent, bigAttrs);
        stSupportedElements.put("p", td);
    }

    protected static void addPreElement(Map stSupportedElements) {
        String name = "pre";
        ArrayList preContent = new ArrayList(inlineContent.size());
        preContent.addAll(inlineContent);
        Html4StrictDocDesc.removeStringsFromList(preContent, new String[]{"img", "object", "big", "small", "sub", "sup"});
        HtmlTagDesc td = new HtmlTagDesc("pre", true, true, preContent, bigAttrs);
        stSupportedElements.put("pre", td);
    }

    protected static void addScriptElement(Map stSupportedElements) {
        String name = "script";
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        ArrayList atts = new ArrayList(6);
        Html4StrictDocDesc.addSimpleAttribute(atts, "charset");
        Html4StrictDocDesc.addSimpleAttribute(atts, "type");
        Html4StrictDocDesc.addSimpleAttribute(atts, "src");
        Html4StrictDocDesc.addSelfAttribute(atts, "defer");
        Html4StrictDocDesc.addSimpleAttribute(atts, "event");
        Html4StrictDocDesc.addSimpleAttribute(atts, "for");
        HtmlTagDesc td = new HtmlTagDesc("script", true, true, content, atts);
        stSupportedElements.put("script", td);
    }

    protected static void addTableElement(Map stSupportedElements) {
        String name = "table";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        atts.addAll(biggerAttrs);
        Html4StrictDocDesc.addSimpleAttribute(atts, "summary");
        Html4StrictDocDesc.addSimpleAttribute(atts, "width");
        Html4StrictDocDesc.addSimpleAttribute(atts, "border");
        atts.add(new HtmlAttributeDesc("frame", new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"}, 4));
        atts.add(new HtmlAttributeDesc("rules", new String[]{"none", "groups", "rows", "cols", "all"}, 4));
        Html4StrictDocDesc.addSimpleAttribute(atts, "rules");
        Html4StrictDocDesc.addSimpleAttribute(atts, "cellspacing");
        Html4StrictDocDesc.addSimpleAttribute(atts, "cellpadding");
        Html4StrictDocDesc.addSimpleAttribute(atts, "datapagesize");
        List[] contentArray = new List[5];
        int[] contentSequence = new int[]{0, 3, 0, 0, 2};
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("caption");
        contentArray[0] = content;
        content = new ArrayList(2);
        content.add("col");
        content.add("colgroup");
        contentArray[1] = content;
        content = new ArrayList(1);
        content.add("thead");
        contentArray[2] = content;
        content = new ArrayList(1);
        content.add("tfoot");
        contentArray[3] = content;
        content = new ArrayList(1);
        content.add("tbody");
        contentArray[4] = content;
        HtmlTagDesc td = new HtmlTagDesc("table", true, true, contentSequence, contentArray, atts);
        stSupportedElements.put("table", td);
    }

    protected static void addTrElement(Map stSupportedElements) {
        String name = "tr";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 3);
        atts.addAll(bigAttrs);
        atts.add(halignAtt);
        atts.add(valignAtt);
        ArrayList<String> content = new ArrayList<String>(2);
        content.add("th");
        content.add("td");
        HtmlTagDesc td = new HtmlTagDesc("tr", true, false, content, atts);
        td.addImplicitContainer((HtmlTagDesc)stSupportedElements.get("tbody"));
        stSupportedElements.put("tr", td);
    }

    protected static void addUlElement(Map stSupportedElements) {
        String name = "ul";
        HtmlTagDesc td = new HtmlTagDesc("ul", true, true, listContent, bigAttrs);
        stSupportedElements.put("ul", td);
    }
}

