/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

public class HtmlAttributeDesc {
    public static final int REQUIRED = 1;
    public static final int CURRENT = 2;
    public static final int CONREF = 3;
    public static final int IMPLIED = 4;
    public static final int OTHER = 5;
    private String _name;
    private int _kind;
    private String[] _permittedValues;

    public HtmlAttributeDesc(String name, String[] permittedValues, int kind) {
        this._name = name;
        this._permittedValues = permittedValues;
        this._kind = kind;
    }

    public HtmlAttributeDesc(String name) {
        this._name = name;
        this._permittedValues = null;
        this._kind = 4;
    }

    public String getName() {
        return this._name;
    }

    public boolean nameMatches(String name) {
        return this._name.equals(name);
    }

    public boolean valueOK(String name, String value) {
        if (this._permittedValues == null) {
            return true;
        }
        if (value == null) {
            return this._permittedValues.length == 1 && this._permittedValues[0].equals(name);
        }
        value = value.toLowerCase();
        for (int i = 0; i < this._permittedValues.length; ++i) {
            if (!this._permittedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired() {
        return this._kind == 1;
    }
}

