/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlStack;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlTempTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHAttribute;
import edu.harvard.hul.ois.jhove.module.html.JHCloseTag;
import edu.harvard.hul.ois.jhove.module.html.JHDoctype;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import edu.harvard.hul.ois.jhove.module.html.JHErrorElement;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import edu.harvard.hul.ois.jhove.module.html.JHPCData;
import edu.harvard.hul.ois.jhove.module.html.MessageConstants;
import edu.harvard.hul.ois.jhove.module.utf8.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.xml.HtmlMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HtmlDocDesc {
    private HtmlMetadata metadata;
    protected static HashMap commonTags;
    protected Map supportedElements;
    protected HtmlTagDesc htmlElement;
    protected HtmlTagDesc headElement;
    protected HtmlTagDesc bodyElement;
    protected HtmlTagDesc framesetElement;
    private HtmlStack elementStack;
    protected static String[] headings;

    public boolean validate(List elements, RepInfo info) {
        this.metadata = new HtmlMetadata();
        this.elementStack = new HtmlStack();
        this.elementStack.setHeadElement(this.headElement);
        this.elementStack.setBodyElement(this.bodyElement);
        this.elementStack.setFramesetElement(this.framesetElement);
        for (JHElement elem : elements) {
            if (elem instanceof JHDoctype) continue;
            if (elem instanceof JHOpenTag) {
                this.doOpenTag((JHOpenTag)elem, info);
                continue;
            }
            if (elem instanceof JHCloseTag) {
                this.doCloseTag((JHCloseTag)elem, info);
                continue;
            }
            if (elem instanceof JHErrorElement) {
                HtmlDocDesc.doErrorElement((JHErrorElement)elem, info);
                continue;
            }
            if (!(elem instanceof JHPCData)) continue;
            this.doPCData((JHPCData)elem, info, this.metadata);
        }
        if (!this.elementStack.isHeadSeen()) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_11));
            info.setValid(false);
        }
        return true;
    }

    public HtmlMetadata getMetadata() {
        return this.metadata;
    }

    protected void init() {
        this.htmlElement = (HtmlTagDesc)this.supportedElements.get("html");
        this.headElement = (HtmlTagDesc)this.supportedElements.get("head");
        this.bodyElement = (HtmlTagDesc)this.supportedElements.get("body");
    }

    private void doOpenTag(JHOpenTag tag, RepInfo info) {
        HtmlTagDesc tagDesc;
        String name = tag.getName().toLowerCase();
        boolean unknownTag = false;
        String msg = tag.getErrorMessage();
        if (msg != null) {
            info.setMessage((Message)new ErrorMessage(msg, "Name = " + name + ", Line = " + tag.getLine() + ", Column = " + tag.getColumn()));
            info.setWellFormed(false);
        }
        if (this.elementStack.isEmpty() && !"html".equals(name)) {
            JHOpenTag fakeTag = new JHOpenTag("html");
            fakeTag.setElement(this.htmlElement);
            this.elementStack.push(fakeTag);
        }
        if ((tagDesc = (HtmlTagDesc)this.supportedElements.get(name)) == null) {
            unknownTag = true;
        }
        if (!unknownTag && !this.checkElementContext(tag, info)) {
            String toptag = null;
            if (!this.elementStack.isEmpty()) {
                JHOpenTag top = this.elementStack.top();
                toptag = top.getName();
            }
            info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_4, "Name = " + name + ", " + (toptag != null ? "Container = " + toptag + ", " : "") + "Line = " + tag.getLine() + ", Column = " + tag.getColumn()));
            info.setValid(false);
        }
        if (unknownTag) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_6, "Name = " + name + ", Line = " + tag.getLine() + ", Column = " + tag.getColumn()));
            info.setValid(false);
            tagDesc = new HtmlTempTagDesc(name);
        }
        if (!unknownTag && info.getWellFormed() == 1) {
            List atts = tag.getAttributes();
            Iterator iter = atts.iterator();
            ArrayList<String> attNames = new ArrayList<String>(atts.size());
            while (iter.hasNext()) {
                JHAttribute att = (JHAttribute)iter.next();
                String attName = att.getName();
                attNames.add(attName);
                String attVal = att.getValue();
                HtmlAttributeDesc attDesc = tagDesc.namedAttDesc(attName);
                if (attDesc == null) {
                    info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_7, "Name = " + name + ", Attribute = " + attName + ", Line = " + att.getLine() + ", Column = " + att.getColumn()));
                    info.setValid(false);
                } else if (!attDesc.valueOK(attName, attVal)) {
                    info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_8, "Element = " + name + ", Attribute = " + attName + ", Value = " + attVal + ", Line = " + att.getLine() + ", Column = " + att.getColumn()));
                    info.setValid(false);
                }
                if (attVal == null) continue;
                Iterator entIter = tag.getEntities(attVal).iterator();
                Utf8BlockMarker utf8BM = this.metadata.getUtf8BlockMarker();
                while (entIter.hasNext()) {
                    String ent = (String)entIter.next();
                    this.metadata.addEntity(ent);
                    try {
                        if (ent.charAt(1) != '#') continue;
                        int entval = Integer.parseInt(ent.substring(2, ent.length() - 1));
                        utf8BM.markBlock(entval);
                    }
                    catch (Exception exception) {}
                }
            }
            List missingAtts = tagDesc.missingRequiredAttributes(attNames);
            if (!missingAtts.isEmpty()) {
                info.setValid(false);
                for (String matt : missingAtts) {
                    info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_9, "Tag = " + name + ", Attribute = " + matt + ", Line = " + tag.getLine() + ", Column = " + tag.getColumn()));
                }
            }
        }
        tag.processElement(this.metadata);
        if (tagDesc.isTemp() || !tagDesc.isContentEmpty()) {
            tag.setElement(tagDesc);
            this.elementStack.push(tag);
        }
    }

    private void doCloseTag(JHCloseTag tag, RepInfo info) {
        String name = tag.getName();
        int idx = this.elementStack.search(name);
        if (idx == -1) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_10, "Name = " + name + ", Line = " + tag.getLine() + ", Column = " + tag.getColumn()));
            info.setValid(false);
        } else {
            this.elementStack.popTo(idx);
        }
    }

    private static void doErrorElement(JHErrorElement elem, RepInfo info) {
        elem.reportError(info);
    }

    private void doPCData(JHPCData elem, RepInfo info, HtmlMetadata metadata) {
        if (this.elementStack.isEmpty()) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_12));
            info.setValid(false);
            return;
        }
        HtmlTagDesc top = this.elementStack.top().getElement();
        if (top.isTemp() || top.allowsPCData()) {
            elem.processPCData(this.elementStack, metadata);
            return;
        }
        while (!top.isCloseTagRequired() && this.elementStack.size() > 2) {
            this.elementStack.popp();
            top = this.elementStack.top().getElement();
            if (!top.allowsPCData()) continue;
            elem.processPCData(this.elementStack, metadata);
            return;
        }
        info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_13, "Line = " + elem.getLine() + ", Column = " + elem.getColumn()));
        info.setValid(false);
    }

    private boolean checkElementContext(JHOpenTag elem, RepInfo info) {
        String name = elem.getName();
        if (this.elementStack.isEmpty()) {
            return "html".equals(name);
        }
        if (this.elementStack.excludesTag(name)) {
            return false;
        }
        JHOpenTag top = this.elementStack.top();
        while (true) {
            if (top.canGetMore() && top.allowsTag(name, this)) {
                top.countComponent();
                return true;
            }
            if (!top.canAdvance()) break;
            top.advanceIndex();
        }
        HtmlTagDesc topElem = top.getElement();
        if (topElem == this.htmlElement) {
            if (!this.elementStack.isHeadSeen() && this.headElement.allowsTag(name, this)) {
                JHOpenTag fakeTag = new JHOpenTag("head");
                fakeTag.setElement(this.headElement);
                this.elementStack.push(fakeTag);
                return true;
            }
            if (!this.elementStack.isBodySeen() && this.bodyElement != null && this.bodyElement.allowsTag(name, this)) {
                JHOpenTag fakeTag = new JHOpenTag("body");
                fakeTag.setElement(this.bodyElement);
                this.elementStack.push(fakeTag);
                return true;
            }
            return false;
        }
        if (topElem == this.headElement) {
            if ("body".equals(name) || "frameset".equals(name)) {
                this.elementStack.popp();
                this.elementStack.push(elem);
                return true;
            }
            if (!this.elementStack.isBodySeen() && this.bodyElement != null && this.bodyElement.allowsTag(name, this)) {
                this.elementStack.popp();
                JHOpenTag fakeTag = new JHOpenTag("body");
                fakeTag.setElement(this.bodyElement);
                this.elementStack.push(fakeTag);
                return true;
            }
            return false;
        }
        boolean complained = false;
        boolean searchStack = false;
        if (this.elementStack.size() > 2) {
            Iterator iter = this.elementStack.iterator();
            iter.next();
            while (iter.hasNext()) {
                JHOpenTag otag = (JHOpenTag)iter.next();
                if (!otag.allowsTag(name, this)) continue;
                searchStack = true;
                break;
            }
        }
        if (searchStack) {
            while (this.elementStack.size() > 2) {
                if (!complained && (topElem = (top = this.elementStack.top()).getElement()).isCloseTagRequired()) {
                    info.setValid(false);
                    info.setMessage((Message)new ErrorMessage(MessageConstants.HTML_HUL_5, "Name = " + name + ", Container = " + top.getName() + ", Line = " + elem.getLine() + ", Column = " + elem.getColumn()));
                }
                this.elementStack.popp();
                top = this.elementStack.top();
                if (top.allowsTag(name, this)) {
                    return true;
                }
                if (!this.elementStack.isEmpty()) continue;
                break;
            }
        }
        return false;
    }

    protected static void addStringsToList(String[] names, List lst) {
        for (int i = 0; i < names.length; ++i) {
            lst.add(names[i]);
        }
    }

    protected static void addSimpleAttribute(List atts, String name) {
        atts.add(new HtmlAttributeDesc(name));
    }

    protected static void addRequiredAttribute(List atts, String name) {
        atts.add(new HtmlAttributeDesc(name, null, 1));
    }

    protected static void addSelfAttribute(List atts, String name) {
        atts.add(new HtmlAttributeDesc(name, new String[]{name}, 4));
    }

    protected static void removeStringsFromList(List lst, String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            lst.remove(strs[i]);
        }
    }

    protected void pushElementStack(JHOpenTag tag) {
        this.elementStack.push(tag);
    }

    static {
        headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    }
}

