/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHAttribute;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import edu.harvard.hul.ois.jhove.module.xml.HtmlMetadata;
import java.util.ArrayList;
import java.util.List;

public class JHOpenTag
extends JHElement {
    public String _name;
    public List _attributes;
    private HtmlTagDesc _element;
    private String _errorMessage;
    private int _contentIdx;
    private int _elementCount;

    public JHOpenTag(List elements, String name, List attrs, int line, int column) {
        super(elements);
        this._name = name.toLowerCase();
        this._attributes = attrs;
        this._line = line;
        this._column = column;
        this._contentIdx = 0;
        this._elementCount = 0;
    }

    public JHOpenTag(List elements, String name, List attrs, int line, int column, String message) {
        this(elements, name, attrs, line, column);
        this._errorMessage = message;
    }

    public JHOpenTag(String name) {
        super(null);
        this._name = name;
        this._attributes = new ArrayList(1);
        this._contentIdx = 0;
    }

    public void setElement(HtmlTagDesc element) {
        this._element = element;
    }

    public HtmlTagDesc getElement() {
        return this._element;
    }

    public String getName() {
        return this._name;
    }

    public List getAttributes() {
        return this._attributes;
    }

    protected void processElement(HtmlMetadata mdata) {
        if ("html".equals(this._name)) {
            this.processHtml(mdata);
        } else if ("meta".equals(this._name)) {
            this.processMeta(mdata);
        } else if ("a".equals(this._name)) {
            this.processA(mdata);
        } else if ("img".equals(this._name)) {
            this.processImg(mdata);
        } else if ("frame".equals(this._name)) {
            this.processFrame(mdata);
        } else if ("script".equals(this._name)) {
            this.processScript(mdata);
        }
        for (JHAttribute attr : this._attributes) {
            if (!"lang".equals(attr.getName()) || attr.getValue() == null) continue;
            mdata.addLanguage(attr.getValue());
        }
    }

    protected boolean allowsTag(String tag, HtmlDocDesc doc) {
        return this._element.allowsTag(tag, this._contentIdx, doc);
    }

    protected boolean canGetMore() {
        return this._element.canGetMoreAt(this._contentIdx, this._elementCount);
    }

    protected void countComponent() {
        ++this._elementCount;
    }

    protected void advanceIndex() {
        ++this._contentIdx;
        this._elementCount = 0;
    }

    protected boolean canAdvance() {
        return this._element.canAdvanceFrom(this._contentIdx, this._elementCount);
    }

    protected String getErrorMessage() {
        return this._errorMessage;
    }

    private void processHtml(HtmlMetadata mdata) {
        String lang = null;
        for (JHAttribute attr : this._attributes) {
            if (!"lang".equals(attr.getName())) continue;
            lang = attr.getValue();
        }
        if (lang != null) {
            mdata.setLanguage(lang);
        }
    }

    private void processMeta(HtmlMetadata mdata) {
        String name = null;
        String httpeq = null;
        String content = null;
        for (JHAttribute attr : this._attributes) {
            String attname = attr.getName();
            String attval = attr.getValue();
            if ("name".equals(attname)) {
                name = attval;
            }
            if ("http-equiv".equals(attname)) {
                httpeq = attval;
            }
            if (!"content".equals(attname)) continue;
            content = attval;
        }
        if (name != null || httpeq != null || content != null) {
            ArrayList<Property> plist = new ArrayList<Property>(3);
            if (name != null) {
                plist.add(new Property("Name", PropertyType.STRING, (Object)name));
            }
            if (httpeq != null) {
                plist.add(new Property("Httpequiv", PropertyType.STRING, httpeq));
            }
            if (content != null) {
                plist.add(new Property("Content", PropertyType.STRING, content));
            }
            mdata.addMeta(new Property("Meta", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private void processA(HtmlMetadata mdata) {
        for (JHAttribute attr : this._attributes) {
            if (!"href".equals(attr.getName())) continue;
            String link = attr.getValue();
            if (link.length() <= 0 || link.charAt(0) == '#') break;
            mdata.addLink(link);
            break;
        }
    }

    private void processImg(HtmlMetadata mdata) {
        String alt = null;
        String longdesc = null;
        String src = null;
        int height = -1;
        int width = -1;
        for (JHAttribute attr : this._attributes) {
            String attname = attr.getName();
            String attval = attr.getValue();
            if ("alt".equals(attname)) {
                alt = attval;
                continue;
            }
            if ("src".equals(attname)) {
                src = attval;
                continue;
            }
            if ("longdesc".equals(attname)) {
                longdesc = attval;
                continue;
            }
            if ("height".equals(attname)) {
                try {
                    height = Integer.parseInt(attval);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"width".equals(attname)) continue;
            try {
                width = Integer.parseInt(attval);
            }
            catch (Exception exception) {}
        }
        ArrayList<Property> plist = new ArrayList<Property>(5);
        if (alt != null) {
            plist.add(new Property("Alt", PropertyType.STRING, alt));
        }
        if (longdesc != null) {
            plist.add(new Property("Longdesc", PropertyType.STRING, longdesc));
        }
        if (src != null) {
            plist.add(new Property("Src", PropertyType.STRING, src));
        }
        if (height >= 0) {
            plist.add(new Property("Height", PropertyType.INTEGER, (Object)new Integer(height)));
        }
        if (width >= 0) {
            plist.add(new Property("Width", PropertyType.INTEGER, (Object)new Integer(width)));
        }
        if (!plist.isEmpty()) {
            mdata.addImage(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private void processFrame(HtmlMetadata mdata) {
        String name = null;
        String title = null;
        String src = null;
        String longdesc = null;
        for (JHAttribute attr : this._attributes) {
            String attname = attr.getName();
            String attval = attr.getValue();
            if ("name".equals(attname)) {
                name = attval;
                continue;
            }
            if ("title".equals(attname)) {
                title = attval;
                continue;
            }
            if ("src".equals(attname)) {
                src = attval;
                continue;
            }
            if (!"longdesc".equals(attname)) continue;
            longdesc = attval;
        }
        ArrayList<Property> plist = new ArrayList<Property>(4);
        if (name != null) {
            plist.add(new Property("Name", PropertyType.STRING, name));
        }
        if (title != null) {
            plist.add(new Property("Title", PropertyType.STRING, title));
        }
        if (longdesc != null) {
            plist.add(new Property("Longdesc", PropertyType.STRING, longdesc));
        }
        if (src != null) {
            plist.add(new Property("src", PropertyType.STRING, src));
        }
        if (!plist.isEmpty()) {
            mdata.addFrame(new Property("Frame", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private void processScript(HtmlMetadata mdata) {
        for (JHAttribute attr : this._attributes) {
            String attname = attr.getName();
            String attval = attr.getValue();
            if (!"type".equals(attname) || attval.length() <= 0) continue;
            mdata.addScript(attval);
        }
    }
}

