/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class JDump
extends Dump {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java JDump file");
            System.exit(-1);
        }
        try (FileInputStream file = new FileInputStream(args[0]);
             BufferedInputStream buffer = new BufferedInputStream(file);
             DataInputStream stream = new DataInputStream(buffer);){
            boolean bigEndian = true;
            long os = 0L;
            boolean endOfImage = false;
            boolean readingECS = false;
            boolean haveCode = false;
            int nECS = 0;
            int code = 0;
            while (!endOfImage) {
                int length;
                int n;
                if (!readingECS) {
                    if (!haveCode) {
                        code = stream.readUnsignedByte();
                        while (stream.readUnsignedByte() == 255) {
                            System.out.println(JDump.leading((long)os, (int)8) + os + ": fill 0xff");
                            ++os;
                        }
                    }
                } else {
                    boolean ff = false;
                    int length2 = 0;
                    while (true) {
                        code = stream.readUnsignedByte();
                        ++length2;
                        if (code == 255) {
                            ff = true;
                            continue;
                        }
                        if (!ff) continue;
                        if (code != 0) break;
                        ff = false;
                    }
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": ECS" + nECS + " " + (length2 -= 2) + " ...");
                    os += (long)length2;
                    ++nECS;
                    readingECS = false;
                    haveCode = true;
                    continue;
                }
                if (code == 1) {
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": TEM");
                } else if (code >= 192 && code <= 195 || code >= 197 && code <= 199 || code >= 201 && code <= 203 || code >= 205 && code <= 207) {
                    int i;
                    n = code - 192;
                    int length3 = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int P = stream.readUnsignedByte();
                    int Y = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int X = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int Nf = stream.readUnsignedByte();
                    int[] Ci = new int[Nf];
                    int[] Hi = new int[Nf];
                    int[] Tqi = new int[Nf];
                    for (i = 0; i < Nf; ++i) {
                        Ci[i] = stream.readUnsignedByte();
                        Hi[i] = stream.readUnsignedByte();
                        Tqi[i] = stream.readUnsignedByte();
                    }
                    System.out.print(JDump.leading((long)os, (int)8) + os + ": SOF" + n + " " + length3 + ": " + P + " " + X + "x" + Y + " " + Nf + ":");
                    for (i = 0; i < Nf; ++i) {
                        System.out.print(" " + Ci[i] + "," + Hi[i] + "," + Tqi[i]);
                    }
                    System.out.println();
                    os += (long)length3;
                } else if (code == 196) {
                    length = JDump.markerSegment(stream, bigEndian);
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": DHT " + length + " ...");
                    os += (long)length;
                } else if (code == 200) {
                    length = JDump.markerSegment(stream, bigEndian);
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": JPG " + length + " ...");
                    os += (long)length;
                } else if (code == 204) {
                    length = JDump.markerSegment(stream, bigEndian);
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": DAC " + length + " ...");
                    os += (long)length;
                } else if (code >= 208 && code <= 215) {
                    int m = code - 208;
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": RST" + m);
                    readingECS = true;
                } else if (code == 216) {
                    System.out.println(JDump.leading((long)os, (int)8) + os + ": SOI");
                } else {
                    int i;
                    if (code == 217) {
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": EOI");
                        endOfImage = true;
                        break;
                    }
                    if (code == 218) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": SOS " + length + " ...");
                        os += (long)length;
                        readingECS = true;
                    } else if (code == 219) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DQT " + length + " ...");
                        os += (long)length;
                    } else if (code == 220) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DNL " + length + " ...");
                        os += (long)length;
                    } else if (code == 221) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DRI " + length + " ...");
                        os += (long)length;
                    } else if (code == 222) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DHP " + length + " ...");
                        os += (long)length;
                    } else if (code == 223) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": EXP " + length + " ...");
                        os += (long)length;
                    } else if (code == 224) {
                        length = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        String id = JDump.readChars((DataInputStream)stream, (int)5);
                        if ("JFIF\u0000".equals(id)) {
                            int major = stream.readUnsignedByte();
                            int minor = stream.readUnsignedByte();
                            int units = stream.readUnsignedByte();
                            int xDensity = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                            int yDensity = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                            int xThumbnail = stream.readUnsignedByte();
                            int yThumbnail = stream.readUnsignedByte();
                            System.out.print(JDump.leading((long)os, (int)8) + os + ": APP0 \"" + id + "\" " + major + "." + minor + " " + units + " " + xDensity + "x" + yDensity + " " + xThumbnail + "x" + yThumbnail);
                            int n2 = length - 16;
                            if (n2 > 0) {
                                for (int i2 = 0; i2 < n2; ++i2) {
                                    stream.readUnsignedByte();
                                }
                                System.out.print(" " + n2 + " ...");
                            }
                            System.out.println();
                        } else if ("JFXX\u0000".equals(id)) {
                            int ext = stream.readUnsignedByte();
                            String hex = Integer.toHexString(ext);
                            System.out.print(JDump.leading((long)os, (int)8) + os + ": APP0 0x" + JDump.leading((String)hex, (int)2) + hex);
                            int n3 = length - 3;
                            if (n3 > 0) {
                                for (i = 0; i < n3; ++i) {
                                    stream.readUnsignedByte();
                                }
                                System.out.print(" " + n3 + " ...");
                            }
                            System.out.println();
                        } else {
                            System.out.println(JDump.leading((long)os, (int)8) + os + ": APP0 " + length + " ...");
                            for (int i3 = 2; i3 < length; ++i3) {
                                stream.readUnsignedByte();
                            }
                        }
                        os += (long)length;
                    } else if (code >= 225 && code <= 239) {
                        n = code - 224;
                        int length4 = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        if ((n == 1 || n == 2) && length4 >= 8) {
                            String id = JDump.readChars((DataInputStream)stream, (int)4);
                            int NULL = stream.readUnsignedByte();
                            int padding = stream.readUnsignedByte();
                            if ("Exif".equals(id) || "FPXR".equals(id)) {
                                System.out.println(JDump.leading((long)os, (int)8) + os + ": APP" + n + " \"" + id + "\" " + NULL + " " + padding + " " + (length4 - 8) + ": ...");
                            } else {
                                System.out.println(JDump.leading((long)os, (int)8) + os + ": APP" + n + " " + length4 + " ...");
                            }
                            for (i = 8; i < length4; ++i) {
                                stream.readUnsignedByte();
                            }
                        } else {
                            System.out.println(JDump.leading((long)os, (int)8) + os + ": APP" + n + " " + length4 + " ...");
                            for (int i4 = 2; i4 < length4; ++i4) {
                                stream.readUnsignedByte();
                            }
                        }
                        os += (long)length4;
                    } else if (code == 240) {
                        length = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int v = stream.readUnsignedByte();
                        int rev = stream.readUnsignedByte();
                        System.out.print(JDump.leading((long)os, (int)8) + os + ": VER " + v + "." + rev);
                        int n4 = length - 4;
                        if (n4 > 0) {
                            int[] cap = new int[n4];
                            for (i = 0; i < n4; ++i) {
                                cap[i] = stream.readUnsignedByte();
                                System.out.print((i == 0 ? " " : ",") + cap[i]);
                            }
                        }
                        System.out.println();
                        os += (long)length;
                    } else if (code == 241) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DTI " + length + " ...");
                        os += (long)length;
                    } else if (code == 242) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DTT " + length + " ...");
                        os += (long)length;
                    } else if (code == 243) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": SRF " + length + " ...");
                        os += (long)length;
                    } else if (code == 244) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": SRS " + length + " ...");
                        os += (long)length;
                    } else if (code == 245) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DCR " + length + " ...");
                        os += (long)length;
                    } else if (code == 246) {
                        length = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": DQS " + length + " ...");
                        os += (long)length;
                    } else if (code >= 247 && code <= 253) {
                        n = code - 240;
                        int length5 = JDump.markerSegment(stream, bigEndian);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": JPG" + n + " " + length5 + " ...");
                        os += (long)length5;
                    } else if (code == 254) {
                        length = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        String comment = JDump.readChars((DataInputStream)stream, (int)(length - 2));
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": COM \"" + comment + "\"");
                        os += (long)length;
                    } else {
                        length = JDump.markerSegment(stream, bigEndian);
                        String hex = Integer.toHexString(code);
                        System.out.println(JDump.leading((long)os, (int)8) + os + ": RES (0x" + JDump.leading((String)hex, (int)2) + hex + ") " + length + " ...");
                    }
                }
                os += 2L;
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
    }

    private static int markerSegment(DataInputStream stream, boolean bigEndian) throws IOException {
        int length = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
        for (int i = 2; i < length; ++i) {
            stream.readUnsignedByte();
        }
        return length;
    }
}

