/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Stack;

public class J2Dump
extends Dump {
    private static final int[] sigByte = new int[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, 135, 10};
    private static final boolean ENDIAN = true;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java J2Dump file");
            System.exit(-1);
        }
        try {
            FileInputStream file = new FileInputStream(args[0]);
            BufferedInputStream buffer = new BufferedInputStream(file);
            DataInputStream stream = new DataInputStream(buffer);
            J2Dump dump = new J2Dump();
            long os = 0L;
            for (int i = 0; i < 12; ++i) {
                int ch = stream.readUnsignedByte();
                if (ch == sigByte[i]) continue;
                System.out.println("No JPEG 2000 header");
                System.exit(-2);
            }
            os += 12L;
            boolean endOfFile = false;
            Stack<Box> boxStack = new Stack<Box>();
            while (!endOfFile) {
                Box boxtop;
                while (true) {
                    boxtop = null;
                    if (boxStack.isEmpty()) break;
                    boxtop = (Box)boxStack.peek();
                    if (boxtop.bytesLeft > 0L) break;
                    boxStack.pop();
                }
                J2Dump j2Dump = dump;
                ((Object)((Object)j2Dump)).getClass();
                Box box = j2Dump.new Box(stream);
                try {
                    box.read();
                }
                catch (EOFException e) {
                    endOfFile = true;
                    break;
                }
                os += box.length - box.bytesLeft;
                if (boxtop != null) {
                    boxtop.bytesLeft -= box.length;
                }
                System.out.println(J2Dump.leading((long)os, (int)8) + os + ": " + J2Dump.stackPrefix(boxStack) + box.type + " " + box.length);
                if (box.isSuperbox()) {
                    boxStack.push(box);
                } else {
                    os += box.bytesLeft;
                    stream.skipBytes((int)box.bytesLeft);
                }
                if (box.length != 0L) continue;
                endOfFile = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
    }

    private static String stackPrefix(Stack<Box> boxStack) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < boxStack.size(); ++i) {
            Box box = (Box)boxStack.elementAt(i);
            retval.append(box.type.trim() + "/");
        }
        return retval.toString();
    }

    class Box {
        public String type;
        public long length;
        public long bytesLeft;
        public boolean hasBoxes;
        DataInputStream dstream;

        public Box(DataInputStream stream) {
            this.dstream = stream;
        }

        public void read() throws IOException {
            this.length = ModuleBase.readUnsignedInt((DataInputStream)this.dstream, (boolean)true, null);
            long headerLength = 8L;
            this.type = this.read4Chars();
            if (this.length == 1L) {
                this.length = ModuleBase.readSignedLong((DataInputStream)this.dstream, (boolean)true, null);
                headerLength = 16L;
            }
            this.bytesLeft = this.length - headerLength;
        }

        private String read4Chars() throws IOException {
            StringBuffer sbuf = new StringBuffer(4);
            for (int i = 0; i < 4; ++i) {
                int ch = ModuleBase.readUnsignedByte((DataInputStream)this.dstream, null);
                sbuf.append((char)ch);
            }
            return sbuf.toString();
        }

        public boolean isSuperbox() {
            String[] supertypes = new String[]{"asoc", "cgrp", "comp", "drep", "ftbl", "jp2h", "jpch", "jplh", "res ", "uuid"};
            for (int i = 0; i < supertypes.length; ++i) {
                if (!supertypes[i].equals(this.type)) continue;
                return true;
            }
            return false;
        }
    }
}

