/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class AssociationBox
extends JP2Box {
    public AssociationBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        this.hasBoxes = true;
        JP2Box box = null;
        LinkedList<Property> boxProps = new LinkedList<Property>();
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (!box.readBox()) {
                return false;
            }
            Property sdProp = box.selfDescProperty();
            if (sdProp == null) continue;
            boxProps.add(sdProp);
        }
        if (!this.associations.isEmpty()) {
            boxProps.add(new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this.associations));
        }
        Property assocProp = new Property("Association", PropertyType.PROPERTY, PropertyArity.LIST, boxProps);
        if (this._parentBox != null) {
            this._parentBox.addAssociation(assocProp);
        } else {
            this._module.addAssociationProp(assocProp);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected Property selfDescProperty() {
        return null;
    }

    @Override
    protected String getSelfPropName() {
        return "Association Box";
    }
}

