/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.IOException;

public class CRGMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        if (this._ccs.getCurTile() != null) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_14));
            return false;
        }
        int ncomps = this._cs.getNumComponents();
        if (ncomps * 4 != bytesToEat) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_15));
        }
        int[] horOffsets = new int[ncomps];
        int[] vertOffsets = new int[ncomps];
        for (int i = 0; i < ncomps; ++i) {
            horOffsets[i] = this._module.readUnsignedShort(this._dstream);
            vertOffsets[i] = this._module.readUnsignedShort(this._dstream);
        }
        Property[] props = new Property[]{new Property("HorizontalOffsets", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)horOffsets), new Property("VerticalOffsets", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)vertOffsets)};
        this._cs.setCRGProperty(new Property("ComponentRegistration", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)props));
        return true;
    }
}

