/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CaptureResolutionBox
extends JP2Box {
    public CaptureResolutionBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ResolutionBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int vrcNum = this._module.readUnsignedShort(this._dstrm);
        int vrcDenom = this._module.readUnsignedShort(this._dstrm);
        int hrcNum = this._module.readUnsignedShort(this._dstrm);
        int hrcDenom = this._module.readUnsignedShort(this._dstrm);
        int vrcExp = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        int hrcExp = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        Property[] topProps = new Property[]{ResolutionBox.makeResolutionProperty("HorizResolution", hrcNum, hrcDenom, hrcExp), ResolutionBox.makeResolutionProperty("VertResolution", vrcNum, vrcDenom, vrcExp)};
        this._module.addProperty(new Property("CaptureResolution", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)topProps));
        Rational vrc = ResolutionBox.convertToRational(vrcNum, vrcDenom, vrcExp);
        Rational hrc = ResolutionBox.convertToRational(hrcNum, hrcDenom, hrcExp);
        NisoImageMetadata niso = this._module.getCurrentNiso();
        niso.setYSamplingFrequency(vrc);
        niso.setXSamplingFrequency(hrc);
        int RESOLUTION_UNIT_CM = 3;
        niso.setSamplingFrequencyUnit(3);
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Capture Resolution Box";
    }
}

