/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ContCodestreamBox
extends JP2Box {
    public ContCodestreamBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        if (!this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_34, this._module.getFilePos()));
            return false;
        }
        int ncs = this._module.getNCodestreams() + 1;
        this._module.setNCodestreams(ncs);
        Codestream curCodestream = this._module.getCodestream(ncs);
        long len = this._boxHeader.getLength() == 0L ? 0L : this._boxHeader.getDataLength();
        ContCodestream ccs = new ContCodestream(this._module, this._dstrm, len);
        boolean retval = ccs.readCodestream(curCodestream, this._repInfo);
        this.finalizeBytesRead();
        return retval;
    }

    @Override
    protected String getSelfPropName() {
        return "Contiguous Codestream Box";
    }
}

