/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.ListIterator;

public class DataEntryURLBox
extends JP2Box {
    public DataEntryURLBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        int b;
        this.initBytesRead();
        for (int i = 0; i < 4; ++i) {
            int v = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            if (v == 0) continue;
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_17, this._module.getFilePos()));
            this._repInfo.setValid(false);
            break;
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>(512);
        while ((b = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module)) != 0) {
            byteList.add(new Byte((byte)b));
        }
        ListIterator li = byteList.listIterator();
        byte[] byteArr = new byte[byteList.size()];
        int j = 0;
        while (li.hasNext()) {
            byteArr[j] = (Byte)li.next();
        }
        String s = new String(byteArr, "UTF-8");
        if (this._parentBox instanceof UUIDInfoBox) {
            UUIDInfoBox uu = (UUIDInfoBox)this._parentBox;
            uu.setURL(s);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Data Entry URL Box";
    }
}

