/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompositionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class InstructionSetBox
extends JP2Box {
    public InstructionSetBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof CompositionBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int ityp = this._module.readUnsignedShort(this._dstrm);
        boolean hasXO_YO = (ityp & 1) != 0;
        boolean hasWid_Ht = (ityp & 2) != 0;
        boolean hasAnimation = (ityp & 8) != 0;
        boolean hasCrop = (ityp & 0x20) != 0;
        this._module.readUnsignedShort(this._dstrm);
        this._module.readUnsignedInt(this._dstrm);
        int sizeLeft = (int)this._boxHeader.getDataLength() - 8;
        if ((ityp & 0x2B) == 0) {
            if (sizeLeft != 0) {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_29, this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        } else {
            ArrayList<Property> instProps = new ArrayList<Property>(11);
            while (sizeLeft >= 0) {
                if (hasXO_YO) {
                    long xo = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("HorizontalOffset", PropertyType.LONG, (Object)xo));
                    long yo = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("VerticalOffset", PropertyType.LONG, (Object)yo));
                    sizeLeft -= 8;
                }
                if (hasWid_Ht) {
                    long width = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("Width", PropertyType.LONG, (Object)width));
                    long height = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("Height", PropertyType.LONG, (Object)height));
                    sizeLeft -= 8;
                }
                if (hasAnimation) {
                    long life = this._module.readUnsignedInt(this._dstrm);
                    boolean persist = (life & Integer.MIN_VALUE) != 0L;
                    instProps.add(new Property("Persist", PropertyType.BOOLEAN, (Object)persist));
                    instProps.add(new Property("Life", PropertyType.LONG, (Object)(life &= Integer.MAX_VALUE)));
                    long nextuse = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("NextUse", PropertyType.LONG, (Object)nextuse));
                    sizeLeft -= 8;
                }
                if (hasCrop) {
                    long xc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("HorizontalCropOffset", PropertyType.LONG, (Object)xc));
                    long yc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("VerticalCropOffset", PropertyType.LONG, (Object)yc));
                    long wc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("CroppedWidth", PropertyType.LONG, (Object)wc));
                    long hc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("CroppedHeight", PropertyType.LONG, (Object)hc));
                    sizeLeft -= 16;
                }
                if (sizeLeft >= 0) continue;
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_28, this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        }
        this.finalizeBytesRead();
        return true;
    }
}

