/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class OpacityBox
extends JP2Box {
    public OpacityBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ComposLayerHdrBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        ArrayList<Property> propList = new ArrayList<Property>(4);
        int otyp = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        propList.add(this._module.addIntegerProperty("Type", otyp, JP2Strings.opacityTypeStr));
        if (otyp > 2) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_36, this._module.getFilePos()));
            this._repInfo.setValid(false);
            return false;
        }
        int bytesLeft = (int)this._boxHeader.getDataLength() - 1;
        if (bytesLeft > 0) {
            int nch = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            int[] keys = new int[nch];
            int keysize = (bytesLeft - 1) / nch;
            for (int i = 0; i < nch; ++i) {
                int chkey = 0;
                for (int j = 0; j < keysize; ++j) {
                    chkey = (chkey << 8) + ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
                }
                keys[i] = chkey;
            }
            propList.add(new Property("ChromaKeyValues", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)keys));
        }
        ((ComposLayerHdrBox)this._parentBox).addOpacity(new Property("Opacity", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Opacity Box";
    }
}

