/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;

public class POCMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int nChanges;
        int compIdxBytes = this.nCompBytes();
        if (compIdxBytes == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_41));
            return false;
        }
        int changeSize = compIdxBytes < 257 ? 7 : 9;
        if (changeSize * (nChanges = bytesToEat / changeSize) != bytesToEat) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_42));
            return false;
        }
        Property[] changes = new Property[nChanges];
        for (int i = 0; i < nChanges; ++i) {
            int rspoc = this._module.readUnsignedShort(this._dstream);
            int cspoc = compIdxBytes < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
            int lyepoc = this._module.readUnsignedShort(this._dstream);
            ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            int cepoc = compIdxBytes < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
            int ppoc = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            Property[] propArr = new Property[]{new Property("StartResolutionLevelIndex", PropertyType.INTEGER, (Object)new Integer(rspoc)), new Property("ComponentIndex", PropertyType.INTEGER, (Object)new Integer(cspoc)), new Property("LayerIndex", PropertyType.INTEGER, (Object)new Integer(lyepoc)), new Property("EndResolutionLevelIndex", PropertyType.INTEGER, (Object)new Integer(cepoc)), new Property("ProgressionOrder", PropertyType.INTEGER, (Object)new Integer(ppoc))};
            changes[i] = new Property("Change", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArr);
        }
        MainOrTile cs = this.getMainOrTile();
        cs.setPOCProperty(new Property("ProgressionOrderChange", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)changes));
        return true;
    }
}

