/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;

public class PPMMarkerSegment
extends MarkerSegment {
    public PPMMarkerSegment() {
        this._ccs.setPPMSeen(true);
    }

    @Override
    protected boolean process(int bytesToEat) throws IOException {
        ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        --bytesToEat;
        while (bytesToEat > 0) {
            long nppm = this._module.readUnsignedInt(this._dstream);
            if (nppm > (long)(bytesToEat -= 4)) {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_43));
                return false;
            }
            this._cs.addPPMLength(nppm);
            this._module.skipBytes(this._dstream, (int)nppm, this._module);
            bytesToEat = (int)((long)bytesToEat - nppm);
        }
        return true;
    }
}

