/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RGNMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int compIdxBytes = this.nCompBytes();
        if (compIdxBytes == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_50));
            return false;
        }
        int compIdx = compIdxBytes < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
        int srgn = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int sprgn = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        MainOrTile cs = this.getMainOrTile();
        ArrayList<Property> propList = new ArrayList<Property>(2);
        propList.add(new Property("ROIStyle", PropertyType.INTEGER, (Object)new Integer(srgn)));
        propList.add(new Property("ROIParameter", PropertyType.INTEGER, (Object)new Integer(sprgn)));
        cs.setCompProperty(compIdx, new Property("RegionOfInterest", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

