/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CaptureResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DDResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ResolutionBox
extends JP2Box {
    public ResolutionBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        JP2Box box;
        this.initBytesRead();
        this.hasBoxes = true;
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (box instanceof CaptureResolutionBox) {
                if (box.readBox()) continue;
                return false;
            }
            if (box instanceof DDResolutionBox) {
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        this.finalizeBytesRead();
        return true;
    }

    public static Property makeResolutionProperty(String name, int num, int denom, int exp) {
        int NUMBER_FOR_RATIONAL = 3;
        ArrayList<Property> resList = new ArrayList<Property>(3);
        resList.add(new Property("Numerator", PropertyType.INTEGER, (Object)new Integer(num)));
        resList.add(new Property("Denominator", PropertyType.INTEGER, (Object)new Integer(denom)));
        resList.add(new Property("Exponent", PropertyType.INTEGER, (Object)new Integer(exp)));
        Property res = new Property(name, PropertyType.PROPERTY, PropertyArity.LIST, resList);
        return res;
    }

    public static Rational convertToRational(int num, int denom, int exp) {
        int POWER = 10;
        int FROM_M_TO_CM = 100;
        return new Rational((int)((double)num * Math.pow(10.0, exp)), denom * 100);
    }

    @Override
    protected String getSelfPropName() {
        return "Resolution Box";
    }
}

