/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasure3DC;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureAD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureLD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasurePD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureRD3;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExDataProjection;
import org.verapdf.model.baselayer.Object;

public class GFAExDataProjection
extends GFAObject
implements AExDataProjection {
    public GFAExDataProjection(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AExDataProjection");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "M3DREF": {
                return this.getM3DREF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getM3DREF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getM3DREF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getM3DREF1_7() {
        COSObject object = this.getM3DREFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getM3DREFDictionary1_7(object.getDirectBase(), "M3DREF");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getM3DREFDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "3DC": {
                return new GFA3DMeasure3DC(base, this.baseObject, keyName);
            }
            case "AD3": {
                return new GFA3DMeasureAD3(base, this.baseObject, keyName);
            }
            case "LD3": {
                return new GFA3DMeasureLD3(base, this.baseObject, keyName);
            }
            case "PD3": {
                return new GFA3DMeasurePD3(base, this.baseObject, keyName);
            }
            case "RD3": {
                return new GFA3DMeasureRD3(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    @Override
    public Boolean getcontainsM3DREF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("M3DREF"));
    }

    public COSObject getM3DREFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("M3DREF"));
        return object;
    }

    @Override
    public Boolean getisM3DREFIndirect() {
        COSObject M3DREF = this.getM3DREFValue();
        return GFAExDataProjection.getisIndirect(M3DREF);
    }

    @Override
    public String getM3DREFType() {
        COSObject M3DREF = this.getM3DREFValue();
        return this.getObjectType(M3DREF);
    }

    @Override
    public Boolean getM3DREFHasTypeDictionary() {
        COSObject M3DREF = this.getM3DREFValue();
        return GFAExDataProjection.getHasTypeDictionary(M3DREF);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAExDataProjection.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAExDataProjection.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAExDataProjection.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAExDataProjection.getNameValue(Type2);
    }
}

