/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAOOAdditionalStmsArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFATrailerIDArray;
import org.verapdf.gf.model.impl.arlington.GFAXRefStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileTrailer;
import org.verapdf.model.alayer.AOOAdditionalStmsArray;
import org.verapdf.model.alayer.ATrailerIDArray;
import org.verapdf.model.alayer.AXRefStream;
import org.verapdf.tools.StaticResources;

public class GFAFileTrailer
extends GFAObject
implements AFileTrailer {
    public GFAFileTrailer(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFileTrailer");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AdditionalStreams": {
                return this.getAdditionalStreams();
            }
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Info": {
                return this.getInfo();
            }
            case "Root": {
                return this.getRoot();
            }
            case "XRefStream": {
                return this.getXRefStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AOOAdditionalStmsArray> getAdditionalStreams() {
        return this.getAdditionalStreams1_0();
    }

    private List<AOOAdditionalStmsArray> getAdditionalStreams1_0() {
        COSObject object = this.getAdditionalStreamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAOOAdditionalStmsArray> list = new ArrayList<GFAOOAdditionalStmsArray>(1);
            list.add(new GFAOOAdditionalStmsArray((COSArray)object.getDirectBase(), this.baseObject, "AdditionalStreams"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.getAuthCodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSDictionary)object.getDirectBase(), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getEncrypt1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_1() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_1(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_1(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<ATrailerIDArray> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getentryID1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID1_1() {
        COSObject object = this.getentryIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFATrailerIDArray> list = new ArrayList<GFATrailerIDArray>(1);
            list.add(new GFATrailerIDArray((COSArray)object.getDirectBase(), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        return this.getInfo1_0();
    }

    private List<ADocInfo> getInfo1_0() {
        COSObject object = this.getInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSDictionary)object.getDirectBase(), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot() {
        return this.getRoot1_0();
    }

    private List<ACatalog> getRoot1_0() {
        COSObject object = this.getRootValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSDictionary)object.getDirectBase(), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getXRefStream1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream1_5() {
        COSObject object = this.getXRefStreamValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXRefStream> list = new ArrayList<GFAXRefStream>(1);
            list.add(new GFAXRefStream((COSStream)object.getDirectBase(), this.baseObject, "XRefStream"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAdditionalStreams() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AdditionalStreams"));
    }

    public COSObject getAdditionalStreamsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AdditionalStreams"));
        return object;
    }

    @Override
    public Boolean getisAdditionalStreamsIndirect() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAFileTrailer.getisIndirect(AdditionalStreams);
    }

    @Override
    public String getAdditionalStreamsType() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return this.getObjectType(AdditionalStreams);
    }

    @Override
    public Boolean getAdditionalStreamsHasTypeArray() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAFileTrailer.getHasTypeArray(AdditionalStreams);
    }

    @Override
    public Long getAdditionalStreamsArraySize() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAFileTrailer.getArraySize(AdditionalStreams);
    }

    @Override
    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AuthCode"));
    }

    public COSObject getAuthCodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AuthCode"));
        return object;
    }

    @Override
    public Boolean getisAuthCodeIndirect() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAFileTrailer.getisIndirect(AuthCode);
    }

    @Override
    public String getAuthCodeType() {
        COSObject AuthCode = this.getAuthCodeValue();
        return this.getObjectType(AuthCode);
    }

    @Override
    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAFileTrailer.getHasTypeDictionary(AuthCode);
    }

    @Override
    public Boolean getcontainsDocChecksum() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DocChecksum"));
    }

    public COSObject getDocChecksumValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DocChecksum"));
        return object;
    }

    @Override
    public Boolean getisDocChecksumIndirect() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return GFAFileTrailer.getisIndirect(DocChecksum);
    }

    @Override
    public String getDocChecksumType() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return this.getObjectType(DocChecksum);
    }

    @Override
    public Boolean getDocChecksumHasTypeName() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return GFAFileTrailer.getHasTypeName(DocChecksum);
    }

    @Override
    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        return object;
    }

    @Override
    public String getEncryptType() {
        COSObject Encrypt = this.getEncryptValue();
        return this.getObjectType(Encrypt);
    }

    @Override
    public Boolean getEncryptHasTypeDictionary() {
        COSObject Encrypt = this.getEncryptValue();
        return GFAFileTrailer.getHasTypeDictionary(Encrypt);
    }

    @Override
    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ID"));
        return object;
    }

    @Override
    public Boolean getisentryIDIndirect() {
        COSObject entryID = this.getentryIDValue();
        return GFAFileTrailer.getisIndirect(entryID);
    }

    @Override
    public String getentryIDType() {
        COSObject entryID = this.getentryIDValue();
        return this.getObjectType(entryID);
    }

    @Override
    public Boolean getentryIDHasTypeArray() {
        COSObject entryID = this.getentryIDValue();
        return GFAFileTrailer.getHasTypeArray(entryID);
    }

    @Override
    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Info"));
        return object;
    }

    @Override
    public Boolean getisInfoIndirect() {
        COSObject Info = this.getInfoValue();
        return GFAFileTrailer.getisIndirect(Info);
    }

    @Override
    public String getInfoType() {
        COSObject Info = this.getInfoValue();
        return this.getObjectType(Info);
    }

    @Override
    public Boolean getInfoHasTypeDictionary() {
        COSObject Info = this.getInfoValue();
        return GFAFileTrailer.getHasTypeDictionary(Info);
    }

    @Override
    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Prev"));
    }

    public COSObject getPrevValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Prev"));
        return object;
    }

    @Override
    public Boolean getisPrevIndirect() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getisIndirect(Prev);
    }

    @Override
    public String getPrevType() {
        COSObject Prev = this.getPrevValue();
        return this.getObjectType(Prev);
    }

    @Override
    public Boolean getPrevHasTypeInteger() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getHasTypeInteger(Prev);
    }

    @Override
    public Long getPrevIntegerValue() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getIntegerValue(Prev);
    }

    @Override
    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Root"));
    }

    public COSObject getRootValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Root"));
        return object;
    }

    @Override
    public Boolean getisRootIndirect() {
        COSObject Root = this.getRootValue();
        return GFAFileTrailer.getisIndirect(Root);
    }

    @Override
    public String getRootType() {
        COSObject Root = this.getRootValue();
        return this.getObjectType(Root);
    }

    @Override
    public Boolean getRootHasTypeDictionary() {
        COSObject Root = this.getRootValue();
        return GFAFileTrailer.getHasTypeDictionary(Root);
    }

    @Override
    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Size"));
        return object;
    }

    @Override
    public Boolean getisSizeIndirect() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getisIndirect(Size);
    }

    @Override
    public String getSizeType() {
        COSObject Size = this.getSizeValue();
        return this.getObjectType(Size);
    }

    @Override
    public Boolean getSizeHasTypeInteger() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getHasTypeInteger(Size);
    }

    @Override
    public Long getSizeIntegerValue() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getIntegerValue(Size);
    }

    @Override
    public Boolean getcontainsXRefStm() {
        return this.baseObject.knownKey(ASAtom.getASAtom("XRefStm"));
    }

    public COSObject getXRefStmValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("XRefStm"));
        return object;
    }

    @Override
    public String getXRefStmType() {
        COSObject XRefStm = this.getXRefStmValue();
        return this.getObjectType(XRefStm);
    }

    @Override
    public Boolean getXRefStmHasTypeInteger() {
        COSObject XRefStm = this.getXRefStmValue();
        return GFAFileTrailer.getHasTypeInteger(XRefStm);
    }

    @Override
    public Long getXRefStmIntegerValue() {
        COSObject XRefStm = this.getXRefStmValue();
        return GFAFileTrailer.getIntegerValue(XRefStm);
    }

    @Override
    public Boolean getcontainsXRefStream() {
        return this.getcontainsXRefStm();
    }

    public COSObject getXRefStreamValue() {
        Long offset = this.getXRefStmIntegerValue();
        COSObject object = offset != null ? StaticResources.getDocument().getDocument().getObject(offset) : null;
        return object;
    }

    @Override
    public String getXRefStreamType() {
        COSObject XRefStream = this.getXRefStreamValue();
        return this.getObjectType(XRefStream);
    }

    @Override
    public Boolean getXRefStreamHasTypeStream() {
        COSObject XRefStream = this.getXRefStreamValue();
        return GFAFileTrailer.getHasTypeStream(XRefStream);
    }

    public COSObject getEncryptVValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom("V"));
        return V;
    }

    public COSObject gettrailerCatalogValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom("Root"));
        return Root;
    }

    public COSObject gettrailerInfoValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Info = trailer.getKey(ASAtom.getASAtom("Info"));
        return Info;
    }

    @Override
    public Long getEncryptVIntegerValue() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAFileTrailer.getIntegerValue(EncryptV);
    }

    @Override
    public Boolean getEncryptVHasTypeInteger() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAFileTrailer.getHasTypeInteger(EncryptV);
    }

    @Override
    public Boolean getcontainstrailerCatalogPieceInfo() {
        COSObject trailerCatalog = this.gettrailerCatalogValue();
        return trailerCatalog.knownKey(ASAtom.getASAtom("PieceInfo"));
    }

    @Override
    public Boolean getcontainstrailerInfoModDate() {
        COSObject trailerInfo = this.gettrailerInfoValue();
        return trailerInfo.knownKey(ASAtom.getASAtom("ModDate"));
    }
}

