/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaWindow;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DActivation;
import org.verapdf.model.alayer.ARichMediaWindow;
import org.verapdf.model.baselayer.Object;

public class GFA3DActivation
extends GFAObject
implements A3DActivation {
    public GFA3DActivation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DActivation");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Window": {
                return this.getWindow();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARichMediaWindow> getWindow() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWindow1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaWindow> getWindow1_7() {
        COSObject object = this.getWindowValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaWindow> list = new ArrayList<GFARichMediaWindow>(1);
            list.add(new GFARichMediaWindow((COSDictionary)object.getDirectBase(), this.baseObject, "Window"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("A"));
    }

    public COSObject getADefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return COSName.construct("XA");
            }
        }
        return null;
    }

    public COSObject getAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("A"));
        if (object == null || object.empty()) {
            object = this.getADefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getAHasTypeName() {
        COSObject object = this.getAValue();
        return GFA3DActivation.getHasTypeName(object);
    }

    @Override
    public String getANameValue() {
        COSObject object = this.getAValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsAIS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AIS"));
    }

    public COSObject getAISDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return COSName.construct("L");
            }
        }
        return null;
    }

    public COSObject getAISValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AIS"));
        if (object == null || object.empty()) {
            object = this.getAISDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getAISHasTypeName() {
        COSObject object = this.getAISValue();
        return GFA3DActivation.getHasTypeName(object);
    }

    @Override
    public String getAISNameValue() {
        COSObject object = this.getAISValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsD() {
        return this.baseObject.knownKey(ASAtom.getASAtom("D"));
    }

    public COSObject getDDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return COSName.construct("PI");
            }
        }
        return null;
    }

    public COSObject getDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("D"));
        if (object == null || object.empty()) {
            object = this.getDDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getDHasTypeName() {
        COSObject object = this.getDValue();
        return GFA3DActivation.getHasTypeName(object);
    }

    @Override
    public String getDNameValue() {
        COSObject object = this.getDValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsDIS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DIS"));
    }

    public COSObject getDISDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return COSName.construct("U");
            }
        }
        return null;
    }

    public COSObject getDISValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DIS"));
        if (object == null || object.empty()) {
            object = this.getDISDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getDISHasTypeName() {
        COSObject object = this.getDISValue();
        return GFA3DActivation.getHasTypeName(object);
    }

    @Override
    public String getDISNameValue() {
        COSObject object = this.getDISValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsNP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("NP"));
    }

    public COSObject getNPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getNPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("NP"));
        if (object == null || object.empty()) {
            object = this.getNPDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getNPHasTypeBoolean() {
        COSObject object = this.getNPValue();
        return GFA3DActivation.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsStyle() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Style"));
    }

    public COSObject getStyleDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Embedded");
            }
        }
        return null;
    }

    public COSObject getStyleValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Style"));
        if (object == null || object.empty()) {
            object = this.getStyleDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getStyleHasTypeName() {
        COSObject object = this.getStyleValue();
        return GFA3DActivation.getHasTypeName(object);
    }

    @Override
    public String getStyleNameValue() {
        COSObject object = this.getStyleValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsTB() {
        return this.baseObject.knownKey(ASAtom.getASAtom("TB"));
    }

    public COSObject getTBDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getTBValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("TB"));
        if (object == null || object.empty()) {
            object = this.getTBDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getTBHasTypeBoolean() {
        COSObject object = this.getTBValue();
        return GFA3DActivation.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsTransparent() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Transparent"));
    }

    public COSObject getTransparentDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getTransparentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Transparent"));
        if (object == null || object.empty()) {
            object = this.getTransparentDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getTransparentHasTypeBoolean() {
        COSObject object = this.getTransparentValue();
        return GFA3DActivation.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsWindow() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Window"));
    }

    public COSObject getWindowValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Window"));
        return object;
    }

    @Override
    public Boolean getWindowHasTypeDictionary() {
        COSObject object = this.getWindowValue();
        return GFA3DActivation.getHasTypeDictionary(object);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

