/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFA3DAnimationStyle;
import org.verapdf.gf.model.impl.arlington.GFA3DStreamNameTreeResources;
import org.verapdf.gf.model.impl.arlington.GFA3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DAnimationStyle;
import org.verapdf.model.alayer.A3DStream;
import org.verapdf.model.alayer.A3DStreamNameTreeResources;
import org.verapdf.model.alayer.A3DView;
import org.verapdf.model.alayer.AArrayOf3DView;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AStream;

public class GFA3DStream
extends GFAObject
implements A3DStream {
    public GFA3DStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DStream");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AN": {
                return this.getAN();
            }
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "DV": {
                return this.getDV();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "OnInstantiate": {
                return this.getOnInstantiate();
            }
            case "Resources": {
                return this.getResources();
            }
            case "VA": {
                return this.getVA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<A3DAnimationStyle> getAN() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAN1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DAnimationStyle> getAN1_7() {
        COSObject object = this.getANValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DAnimationStyle> list = new ArrayList<GFA3DAnimationStyle>(1);
            list.add(new GFA3DAnimationStyle((COSDictionary)object.getDirectBase(), this.baseObject, "AN"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getColorSpace2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace2_0() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray2_0(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray2_0(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<A3DView> getDV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDV1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DView> getDV1_6() {
        COSObject object = this.getDVValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DView> list = new ArrayList<GFA3DView>(1);
            list.add(new GFA3DView((COSDictionary)object.getDirectBase(), this.baseObject, "DV"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_6() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_6(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_6(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getF1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_6() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_6() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_6(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_6(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_6() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_6() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getOnInstantiate1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate1_6() {
        COSObject object = this.getOnInstantiateValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "OnInstantiate"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getResources1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources1_6() {
        COSObject object = this.getResourcesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DStreamNameTreeResources> list = new ArrayList<GFA3DStreamNameTreeResources>(1);
            list.add(new GFA3DStreamNameTreeResources((COSDictionary)object.getDirectBase(), this.baseObject, "Resources"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getVA1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA1_6() {
        COSObject object = this.getVAValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DView> list = new ArrayList<GFAArrayOf3DView>(1);
            list.add(new GFAArrayOf3DView((COSArray)object.getDirectBase(), this.baseObject, "VA"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAN() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AN"));
    }

    public COSObject getANValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AN"));
        return object;
    }

    @Override
    public Boolean getANHasTypeDictionary() {
        COSObject object = this.getANValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ColorSpace"));
        return object;
    }

    @Override
    public Boolean getColorSpaceHasTypeArray() {
        COSObject object = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Boolean getColorSpaceHasTypeName() {
        COSObject object = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public String getColorSpaceNameValue() {
        COSObject object = this.getColorSpaceValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DL"));
        return object;
    }

    @Override
    public Boolean getDLHasTypeInteger() {
        COSObject object = this.getDLValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    @Override
    public Long getDLIntegerValue() {
        COSObject object = this.getDLValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public Boolean getcontainsDV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DV"));
    }

    public COSObject getDVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DV"));
        return object;
    }

    @Override
    public Boolean getDVHasTypeDictionary() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getDVHasTypeInteger() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    @Override
    public Boolean getDVHasTypeName() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public Boolean getDVHasTypeString() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeString(object);
    }

    @Override
    public Long getDVIntegerValue() {
        COSObject object = this.getDVValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public String getDVNameValue() {
        COSObject object = this.getDVValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DecodeParms"));
        return object;
    }

    @Override
    public Boolean getDecodeParmsHasTypeArray() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    @Override
    public Long getDecodeParmsArraySize() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getArraySize(object);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject object = this.getFValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getFHasTypeString() {
        COSObject object = this.getFValue();
        return GFA3DStream.getHasTypeString(object);
    }

    @Override
    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FDecodeParms"));
        return object;
    }

    @Override
    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    @Override
    public Long getFDecodeParmsArraySize() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getArraySize(object);
    }

    @Override
    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        return object;
    }

    @Override
    public Boolean getFFilterHasTypeArray() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Boolean getFFilterHasTypeName() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public String getFFilterNameValue() {
        COSObject object = this.getFFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Long getFFilterArraySize() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getArraySize(object);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public Boolean getFilterHasTypeArray() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Long getFilterArraySize() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getArraySize(object);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    @Override
    public Boolean getcontainsOnInstantiate() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OnInstantiate"));
    }

    public COSObject getOnInstantiateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OnInstantiate"));
        return object;
    }

    @Override
    public Boolean getisOnInstantiateIndirect() {
        COSObject object = this.getOnInstantiateValue();
        return GFA3DStream.getisIndirect(object);
    }

    @Override
    public Boolean getOnInstantiateHasTypeStream() {
        COSObject object = this.getOnInstantiateValue();
        return GFA3DStream.getHasTypeStream(object);
    }

    @Override
    public Boolean getcontainsResources() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Resources"));
    }

    public COSObject getResourcesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Resources"));
        return object;
    }

    @Override
    public Boolean getResourcesHasTypeNameTree() {
        COSObject object = this.getResourcesValue();
        return GFA3DStream.getHasTypeNameTree(object);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.getSubtypeValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject object = this.getSubtypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFA3DStream.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsVA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("VA"));
    }

    public COSObject getVAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("VA"));
        return object;
    }

    @Override
    public Boolean getVAHasTypeArray() {
        COSObject object = this.getVAValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    @Override
    public Long getVAArraySize() {
        COSObject object = this.getVAValue();
        return GFA3DStream.getArraySize(object);
    }
}

