/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASoftwareIdentifier;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AMediaPlayerInfo;
import org.verapdf.model.alayer.ASoftwareIdentifier;
import org.verapdf.model.alayer.A_UniversalDictionary;
import org.verapdf.model.baselayer.Object;

public class GFAMediaPlayerInfo
extends GFAObject
implements AMediaPlayerInfo {
    public GFAMediaPlayerInfo(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AMediaPlayerInfo");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "BE": {
                return this.getBE();
            }
            case "MH": {
                return this.getMH();
            }
            case "PID": {
                return this.getPID();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<A_UniversalDictionary> getBE() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBE1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getBE1_5() {
        COSObject object = this.getBEValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSDictionary)object.getDirectBase(), this.baseObject, "BE"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getMH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getMH1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getMH1_5() {
        COSObject object = this.getMHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSDictionary)object.getDirectBase(), this.baseObject, "MH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASoftwareIdentifier> getPID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPID1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ASoftwareIdentifier> getPID1_5() {
        COSObject object = this.getPIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASoftwareIdentifier> list = new ArrayList<GFASoftwareIdentifier>(1);
            list.add(new GFASoftwareIdentifier((COSDictionary)object.getDirectBase(), this.baseObject, "PID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BE"));
    }

    public COSObject getBEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BE"));
        return object;
    }

    @Override
    public Boolean getBEHasTypeDictionary() {
        COSObject object = this.getBEValue();
        return GFAMediaPlayerInfo.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsMH() {
        return this.baseObject.knownKey(ASAtom.getASAtom("MH"));
    }

    public COSObject getMHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MH"));
        return object;
    }

    @Override
    public Boolean getMHHasTypeDictionary() {
        COSObject object = this.getMHValue();
        return GFAMediaPlayerInfo.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsPID() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PID"));
    }

    public COSObject getPIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PID"));
        return object;
    }

    @Override
    public Boolean getPIDHasTypeDictionary() {
        COSObject object = this.getPIDValue();
        return GFAMediaPlayerInfo.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFAMediaPlayerInfo.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }
}

