/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASoliditiesEntry;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASolidities;
import org.verapdf.model.alayer.ASoliditiesEntry;
import org.verapdf.model.baselayer.Object;

public class GFASolidities
extends GFAObject
implements ASolidities {
    public GFASolidities(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASolidities");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ASoliditiesEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ASoliditiesEntry> getEntries1_6() {
        LinkedList<GFASoliditiesEntry> list = new LinkedList<GFASoliditiesEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Default".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFASoliditiesEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Boolean getcontainsDefault() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Default"));
    }

    public COSObject getDefaultValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Default"));
        return object;
    }

    @Override
    public Boolean getDefaultHasTypeNumber() {
        COSObject object = this.getDefaultValue();
        return GFASolidities.getHasTypeNumber(object);
    }

    @Override
    public Double getDefaultNumberValue() {
        COSObject object = this.getDefaultValue();
        if (object != null && object.getType().isNumber()) {
            return object.getReal();
        }
        return null;
    }
}

