/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamAnnotsArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamDocumentArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamEFArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamFormArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamSignatureArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AURTransformParamAnnotsArray;
import org.verapdf.model.alayer.AURTransformParamDocumentArray;
import org.verapdf.model.alayer.AURTransformParamEFArray;
import org.verapdf.model.alayer.AURTransformParamFormArray;
import org.verapdf.model.alayer.AURTransformParamSignatureArray;
import org.verapdf.model.alayer.AURTransformParameters;

public class GFAURTransformParameters
extends GFAObject
implements AURTransformParameters {
    public GFAURTransformParameters(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AURTransformParameters");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Annots": {
                return this.getAnnots();
            }
            case "Document": {
                return this.getDocument();
            }
            case "EF": {
                return this.getEF();
            }
            case "Form": {
                return this.getForm();
            }
            case "Signature": {
                return this.getSignature();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AURTransformParamAnnotsArray> getAnnots() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAnnots1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamAnnotsArray> getAnnots1_5() {
        COSObject object = this.getAnnotsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamAnnotsArray> list = new ArrayList<GFAURTransformParamAnnotsArray>(1);
            list.add(new GFAURTransformParamAnnotsArray((COSArray)object.getDirectBase(), this.baseObject, "Annots"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamDocumentArray> getDocument() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDocument1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamDocumentArray> getDocument1_5() {
        COSObject object = this.getDocumentValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamDocumentArray> list = new ArrayList<GFAURTransformParamDocumentArray>(1);
            list.add(new GFAURTransformParamDocumentArray((COSArray)object.getDirectBase(), this.baseObject, "Document"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamEFArray> getEF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEF1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamEFArray> getEF1_6() {
        COSObject object = this.getEFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamEFArray> list = new ArrayList<GFAURTransformParamEFArray>(1);
            list.add(new GFAURTransformParamEFArray((COSArray)object.getDirectBase(), this.baseObject, "EF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamFormArray> getForm() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getForm1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamFormArray> getForm1_5() {
        COSObject object = this.getFormValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamFormArray> list = new ArrayList<GFAURTransformParamFormArray>(1);
            list.add(new GFAURTransformParamFormArray((COSArray)object.getDirectBase(), this.baseObject, "Form"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamSignatureArray> getSignature() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSignature1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamSignatureArray> getSignature1_5() {
        COSObject object = this.getSignatureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamSignatureArray> list = new ArrayList<GFAURTransformParamSignatureArray>(1);
            list.add(new GFAURTransformParamSignatureArray((COSArray)object.getDirectBase(), this.baseObject, "Signature"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAnnots() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Annots"));
    }

    public COSObject getAnnotsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Annots"));
        return object;
    }

    @Override
    public Boolean getAnnotsHasTypeArray() {
        COSObject object = this.getAnnotsValue();
        return GFAURTransformParameters.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsDocument() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Document"));
    }

    public COSObject getDocumentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Document"));
        return object;
    }

    @Override
    public Boolean getDocumentHasTypeArray() {
        COSObject object = this.getDocumentValue();
        return GFAURTransformParameters.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsEF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EF"));
    }

    public COSObject getEFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EF"));
        return object;
    }

    @Override
    public Boolean getEFHasTypeArray() {
        COSObject object = this.getEFValue();
        return GFAURTransformParameters.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsForm() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Form"));
    }

    public COSObject getFormValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Form"));
        return object;
    }

    @Override
    public Boolean getFormHasTypeArray() {
        COSObject object = this.getFormValue();
        return GFAURTransformParameters.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsMsg() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Msg"));
    }

    public COSObject getMsgValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Msg"));
        return object;
    }

    @Override
    public Boolean getMsgHasTypeStringText() {
        COSObject object = this.getMsgValue();
        return GFAURTransformParameters.getHasTypeStringText(object);
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getPHasTypeBoolean() {
        COSObject object = this.getPValue();
        return GFAURTransformParameters.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsSignature() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Signature"));
    }

    public COSObject getSignatureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Signature"));
        return object;
    }

    @Override
    public Boolean getSignatureHasTypeArray() {
        COSObject object = this.getSignatureValue();
        return GFAURTransformParameters.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFAURTransformParameters.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("2.2");
            }
        }
        return null;
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        if (object == null || object.empty()) {
            object = this.getVDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getVHasTypeName() {
        COSObject object = this.getVValue();
        return GFAURTransformParameters.getHasTypeName(object);
    }
}

