/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ATarget;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.tools.StaticResources;

public class GFATarget
extends GFAObject
implements ATarget {
    public GFATarget(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ATarget");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "T": {
                return this.getT();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ATarget> getT() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getT1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ATarget> getT1_6() {
        COSObject object = this.getTValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFATarget> list = new ArrayList<GFATarget>(1);
            list.add(new GFATarget((COSDictionary)object.getDirectBase(), this.baseObject, "T"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("A"));
    }

    public COSObject getAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("A"));
        return object;
    }

    @Override
    public Boolean getAHasTypeInteger() {
        COSObject object = this.getAValue();
        return GFATarget.getHasTypeInteger(object);
    }

    @Override
    public Boolean getAHasTypeStringText() {
        COSObject object = this.getAValue();
        return GFATarget.getHasTypeStringText(object);
    }

    @Override
    public Long getAIntegerValue() {
        COSObject object = this.getAValue();
        return GFATarget.getIntegerValue(object);
    }

    @Override
    public String getAStringTextValue() {
        COSObject object = this.getAValue();
        return GFATarget.getStringTextValue(object);
    }

    @Override
    public Boolean getcontainsN() {
        return this.baseObject.knownKey(ASAtom.getASAtom("N"));
    }

    public COSObject getNValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("N"));
        return object;
    }

    @Override
    public Boolean getNHasTypeStringByte() {
        COSObject object = this.getNValue();
        return GFATarget.getHasTypeStringByte(object);
    }

    @Override
    public Boolean getnameTreetrailerCatalogNamesEmbeddedFilesContainsNString() {
        COSObject object = this.getNValue();
        if (object == null || object.getType() != COSObjType.COS_STRING) {
            return false;
        }
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom("Root"));
        if (Root == null || !Root.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Names = Root.getKey(ASAtom.getASAtom("Names"));
        if (Names == null || !Names.getType().isDictionaryBased()) {
            return null;
        }
        COSObject EmbeddedFiles = Names.getKey(ASAtom.getASAtom("EmbeddedFiles"));
        if (EmbeddedFiles == null || EmbeddedFiles.getType() != COSObjType.COS_DICT) {
            return false;
        }
        PDNameTreeNode nameTreeNode = PDNameTreeNode.create(EmbeddedFiles);
        return nameTreeNode.getObject(object.getString()) != null;
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        return object;
    }

    @Override
    public Boolean getPHasTypeInteger() {
        COSObject object = this.getPValue();
        return GFATarget.getHasTypeInteger(object);
    }

    @Override
    public Boolean getPHasTypeStringByte() {
        COSObject object = this.getPValue();
        return GFATarget.getHasTypeStringByte(object);
    }

    @Override
    public Long getPIntegerValue() {
        COSObject object = this.getPValue();
        return GFATarget.getIntegerValue(object);
    }

    @Override
    public Boolean getnameTreetrailerCatalogNamesDestsContainsPString() {
        COSObject object = this.getPValue();
        if (object == null || object.getType() != COSObjType.COS_STRING) {
            return false;
        }
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom("Root"));
        if (Root == null || !Root.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Names = Root.getKey(ASAtom.getASAtom("Names"));
        if (Names == null || !Names.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Dests = Names.getKey(ASAtom.getASAtom("Dests"));
        if (Dests == null || Dests.getType() != COSObjType.COS_DICT) {
            return false;
        }
        PDNameTreeNode nameTreeNode = PDNameTreeNode.create(Dests);
        return nameTreeNode.getObject(object.getString()) != null;
    }

    @Override
    public Boolean getcontainsR() {
        return this.baseObject.knownKey(ASAtom.getASAtom("R"));
    }

    public COSObject getRValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("R"));
        return object;
    }

    @Override
    public Boolean getRHasTypeName() {
        COSObject object = this.getRValue();
        return GFATarget.getHasTypeName(object);
    }

    @Override
    public String getRNameValue() {
        COSObject object = this.getRValue();
        return GFATarget.getNameValue(object);
    }

    @Override
    public Boolean getcontainsT() {
        return this.baseObject.knownKey(ASAtom.getASAtom("T"));
    }

    public COSObject getTValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("T"));
        return object;
    }

    @Override
    public Boolean getTHasTypeDictionary() {
        COSObject object = this.getTValue();
        return GFATarget.getHasTypeDictionary(object);
    }

    @Override
    public Long getpagePAnnotsArraySize() {
        COSObject object = this.getPValue();
        COSObject page = GFATarget.getPageObject(object);
        if (page == null || !page.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Annots = page.getKey(ASAtom.getASAtom("Annots"));
        return GFATarget.getArraySize(Annots);
    }

    @Override
    public Boolean getpagePAnnotsHasTypeArray() {
        COSObject object = this.getPValue();
        COSObject page = GFATarget.getPageObject(object);
        if (page == null || !page.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Annots = page.getKey(ASAtom.getASAtom("Annots"));
        return GFATarget.getHasTypeArray(Annots);
    }
}

