/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AEncryptionPublicKey;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionPublicKey
extends GFAObject
implements AEncryptionPublicKey {
    public GFAEncryptionPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionPublicKey");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getRecipients1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_3() {
        COSObject object = this.getRecipientsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSArray)object.getDirectBase(), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CF"));
        return object;
    }

    @Override
    public Boolean getCFHasTypeDictionary() {
        COSObject object = this.getCFValue();
        return GFAEncryptionPublicKey.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EFF"));
        return object;
    }

    @Override
    public Boolean getEFFHasTypeName() {
        COSObject object = this.getEFFValue();
        return GFAEncryptionPublicKey.getHasTypeName(object);
    }

    @Override
    public String getEFFNameValue() {
        COSObject object = this.getEFFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject object = this.getEncryptMetadataValue();
        return GFAEncryptionPublicKey.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return GFAEncryptionPublicKey.getHasTypeName(object);
    }

    @Override
    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("KDFSalt"));
        return object;
    }

    @Override
    public Boolean getisKDFSaltIndirect() {
        COSObject object = this.getKDFSaltValue();
        return GFAEncryptionPublicKey.getisIndirect(object);
    }

    @Override
    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject object = this.getKDFSaltValue();
        return GFAEncryptionPublicKey.getHasTypeStringByte(object);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct(40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return GFAEncryptionPublicKey.getHasTypeInteger(object);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject object = this.getLengthValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSInteger.construct(0L);
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getPHasTypeBitmask() {
        COSObject object = this.getPValue();
        return GFAEncryptionPublicKey.getHasTypeBitmask(object);
    }

    @Override
    public Long getPBitmaskValue() {
        COSObject object = this.getPValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Recipients"));
    }

    public COSObject getRecipientsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Recipients"));
        return object;
    }

    @Override
    public Boolean getRecipientsHasTypeArray() {
        COSObject object = this.getRecipientsValue();
        return GFAEncryptionPublicKey.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getStmFHasTypeName() {
        COSObject object = this.getStmFValue();
        return GFAEncryptionPublicKey.getHasTypeName(object);
    }

    @Override
    public String getStmFNameValue() {
        COSObject object = this.getStmFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getStrFHasTypeName() {
        COSObject object = this.getStrFValue();
        return GFAEncryptionPublicKey.getHasTypeName(object);
    }

    @Override
    public String getStrFNameValue() {
        COSObject object = this.getStrFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SubFilter"));
        return object;
    }

    @Override
    public Boolean getSubFilterHasTypeName() {
        COSObject object = this.getSubFilterValue();
        return GFAEncryptionPublicKey.getHasTypeName(object);
    }

    @Override
    public String getSubFilterNameValue() {
        COSObject object = this.getSubFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public Boolean getVHasTypeInteger() {
        COSObject object = this.getVValue();
        return GFAEncryptionPublicKey.getHasTypeInteger(object);
    }

    @Override
    public Long getVIntegerValue() {
        COSObject object = this.getVValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

