/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNumbersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAEncoding;
import org.verapdf.gf.model.impl.arlington.GFAFontDescriptorTrueType;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfNumbersGeneral;
import org.verapdf.model.alayer.AEncoding;
import org.verapdf.model.alayer.AFontDescriptorTrueType;
import org.verapdf.model.alayer.AFontTrueType;
import org.verapdf.model.alayer.AStream;

public class GFAFontTrueType
extends GFAObject
implements AFontTrueType {
    public GFAFontTrueType(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFontTrueType");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Encoding": {
                return this.getEncoding();
            }
            case "FontDescriptor": {
                return this.getFontDescriptor();
            }
            case "ToUnicode": {
                return this.getToUnicode();
            }
            case "Widths": {
                return this.getWidths();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AEncoding> getEncoding() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEncoding1_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AEncoding> getEncoding1_0() {
        COSObject object = this.getEncodingValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAEncoding> list = new ArrayList<GFAEncoding>(1);
            list.add(new GFAEncoding((COSDictionary)object.getDirectBase(), this.baseObject, "Encoding"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AFontDescriptorTrueType> getFontDescriptor() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFontDescriptor1_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AFontDescriptorTrueType> getFontDescriptor1_0() {
        COSObject object = this.getFontDescriptorValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFontDescriptorTrueType> list = new ArrayList<GFAFontDescriptorTrueType>(1);
            list.add(new GFAFontDescriptorTrueType((COSDictionary)object.getDirectBase(), this.baseObject, "FontDescriptor"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getToUnicode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getToUnicode1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getToUnicode1_2() {
        COSObject object = this.getToUnicodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "ToUnicode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getWidths() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWidths1_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getWidths1_0() {
        COSObject object = this.getWidthsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSArray)object.getDirectBase(), this.baseObject, "Widths"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBaseFont() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BaseFont"));
    }

    public COSObject getBaseFontValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BaseFont"));
        return object;
    }

    @Override
    public Boolean getBaseFontHasTypeName() {
        COSObject object = this.getBaseFontValue();
        return GFAFontTrueType.getHasTypeName(object);
    }

    @Override
    public String getBaseFontNameValue() {
        COSObject object = this.getBaseFontValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsEncoding() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Encoding"));
    }

    public COSObject getEncodingValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Encoding"));
        return object;
    }

    @Override
    public Boolean getEncodingHasTypeDictionary() {
        COSObject object = this.getEncodingValue();
        return GFAFontTrueType.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getEncodingHasTypeName() {
        COSObject object = this.getEncodingValue();
        return GFAFontTrueType.getHasTypeName(object);
    }

    @Override
    public String getEncodingNameValue() {
        COSObject object = this.getEncodingValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsFirstChar() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FirstChar"));
    }

    public COSObject getFirstCharValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FirstChar"));
        return object;
    }

    @Override
    public Boolean getFirstCharHasTypeInteger() {
        COSObject object = this.getFirstCharValue();
        return GFAFontTrueType.getHasTypeInteger(object);
    }

    @Override
    public Boolean getcontainsFontDescriptor() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FontDescriptor"));
    }

    public COSObject getFontDescriptorValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontDescriptor"));
        return object;
    }

    @Override
    public Boolean getisFontDescriptorIndirect() {
        COSObject object = this.getFontDescriptorValue();
        return GFAFontTrueType.getisIndirect(object);
    }

    @Override
    public Boolean getFontDescriptorHasTypeDictionary() {
        COSObject object = this.getFontDescriptorValue();
        return GFAFontTrueType.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsLastChar() {
        return this.baseObject.knownKey(ASAtom.getASAtom("LastChar"));
    }

    public COSObject getLastCharValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("LastChar"));
        return object;
    }

    @Override
    public Boolean getLastCharHasTypeInteger() {
        COSObject object = this.getLastCharValue();
        return GFAFontTrueType.getHasTypeInteger(object);
    }

    @Override
    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Name"));
        return object;
    }

    @Override
    public Boolean getNameHasTypeName() {
        COSObject object = this.getNameValue();
        return GFAFontTrueType.getHasTypeName(object);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.getSubtypeValue();
        return GFAFontTrueType.getHasTypeName(object);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject object = this.getSubtypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsToUnicode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ToUnicode"));
    }

    public COSObject getToUnicodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ToUnicode"));
        return object;
    }

    @Override
    public Boolean getisToUnicodeIndirect() {
        COSObject object = this.getToUnicodeValue();
        return GFAFontTrueType.getisIndirect(object);
    }

    @Override
    public Boolean getToUnicodeHasTypeStream() {
        COSObject object = this.getToUnicodeValue();
        return GFAFontTrueType.getHasTypeStream(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFAFontTrueType.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsWidths() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Widths"));
    }

    public COSObject getWidthsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Widths"));
        return object;
    }

    @Override
    public Boolean getWidthsHasTypeArray() {
        COSObject object = this.getWidthsValue();
        return GFAFontTrueType.getHasTypeArray(object);
    }
}

