/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.SeekableCOSParser;

public class SignatureParser
extends SeekableCOSParser {
    private static final Logger LOGGER = Logger.getLogger(SignatureParser.class.getCanonicalName());
    private static final byte[] EOF_STRING = "%%EOF".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] STREAM_STRING = "stream".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ENDSTREAM_STRING = "endstream".getBytes(StandardCharsets.ISO_8859_1);
    private boolean isStream = false;
    private final long[] byteRange = new long[4];
    private int floatingBytesNumber = 0;
    private boolean isStreamEnd = true;
    private final COSDocument document;

    public SignatureParser(SeekableInputStream stream, COSDocument document) throws IOException {
        super(stream);
        this.document = document;
    }

    private void parseDictionary() throws IOException {
        this.getBaseParser().skipSpaces();
        this.getBaseParser().skipExpectedCharacter('<');
        this.getBaseParser().skipExpectedCharacter('<');
        this.getBaseParser().skipSpaces();
        boolean done = false;
        while (!done) {
            this.getBaseParser().skipSpaces();
            char c = (char)this.getSource().peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (!this.parseSignatureNameValuePair()) continue;
            done = true;
        }
    }

    private void passCOSDictionaryValue() throws IOException {
        long numOffset = this.getSource().getOffset();
        COSObject number = this.nextObject();
        this.getBaseParser().skipSpaces();
        if (!this.getBaseParser().isDigit()) {
            return;
        }
        COSObject generationNumber = this.nextObject();
        this.getBaseParser().skipSpaces();
        this.getBaseParser().skipExpectedCharacter('R');
        if (number.getType() != COSObjType.COS_INTEGER) {
            throw new IOException(this.getErrorMessage("expected number but got " + (Object)((Object)number.getType()), numOffset));
        }
        if (generationNumber.getType() != COSObjType.COS_INTEGER) {
            throw new IOException(this.getErrorMessage("expected number but got " + (Object)((Object)generationNumber.getType()), numOffset));
        }
    }

    public long[] getByteRangeBySignatureOffset(long signatureOffset) throws IOException {
        this.getSource().seek(signatureOffset);
        this.skipID();
        this.byteRange[0] = 0L;
        this.parseDictionary();
        this.byteRange[3] = this.getOffsetOfNextEOF(this.getOffsetOfNextXRef(this.byteRange[2])) - this.byteRange[2];
        return this.byteRange;
    }

    public int getFloatingBytesNumberForLastByteRangeObtained() {
        return this.floatingBytesNumber;
    }

    public boolean isStreamEnd() {
        return this.isStreamEnd;
    }

    private boolean parseSignatureNameValuePair() throws IOException {
        COSObject key = this.getName();
        if (key.getType() != COSObjType.COS_NAME) {
            LOGGER.log(Level.FINE, this.getErrorMessage("Invalid signature dictionary"));
            return false;
        }
        if (key.getName() != ASAtom.CONTENTS) {
            this.passCOSDictionaryValue();
            return false;
        }
        this.parseSignatureValue();
        return true;
    }

    private void parseSignatureValue() throws IOException {
        this.getBaseParser().skipSpaces();
        long numOffset1 = this.getSource().getOffset();
        COSObject number = this.nextObject();
        long numOffset2 = this.getSource().getOffset();
        this.getBaseParser().skipSpaces();
        if (!this.getBaseParser().isDigit()) {
            this.byteRange[1] = numOffset1;
            this.byteRange[2] = numOffset2;
            return;
        }
        long genOffset = this.getSource().getOffset();
        COSObject generationNumber = this.nextObject();
        this.getBaseParser().skipSpaces();
        int c = this.getSource().read();
        if (c == 82) {
            if (number.getType() != COSObjType.COS_INTEGER) {
                throw new IOException(this.getErrorMessage("expected number but got " + (Object)((Object)number.getType()), numOffset1));
            }
            if (generationNumber.getType() != COSObjType.COS_INTEGER) {
                throw new IOException(this.getErrorMessage("expected number but got " + (Object)((Object)generationNumber.getType()), genOffset));
            }
            COSKey key = new COSKey(number.getInteger().intValue(), generationNumber.getInteger().intValue());
            long keyOffset = this.document.getOffset(key);
            this.getSource().seek(keyOffset + this.document.getHeader().getHeaderOffset());
            this.parseSignatureValue();
        }
        if (c != 111) {
            throw new IOException(this.getErrorMessage("\"R\" or \"obj\" expected, but '" + (char)c + "' found"));
        }
        this.getBaseParser().skipExpectedCharacter('b');
        this.getBaseParser().skipExpectedCharacter('j');
        this.getBaseParser().skipSpaces();
        numOffset1 = this.getSource().getOffset();
        this.nextObject();
        numOffset2 = this.getSource().getOffset();
        this.byteRange[1] = numOffset1;
        this.byteRange[2] = numOffset2;
    }

    private long getOffsetOfNextXRef(long currentOffset) {
        return this.document.getStartXRefs().stream().filter(offset -> offset > currentOffset).findFirst().orElse(currentOffset);
    }

    private long getOffsetOfNextEOF(long currentOffset) throws IOException {
        byte[] buffer = new byte[EOF_STRING.length];
        this.getSource().seek(currentOffset + this.document.getHeader().getHeaderOffset());
        this.getSource().read(buffer);
        this.getSource().unread(buffer.length - 1);
        this.isStream = false;
        while (this.isStream || !this.isEOFFound(buffer)) {
            byte[] streamCheck = this.isStream ? ENDSTREAM_STRING : STREAM_STRING;
            byte[] streamCheckBuff = new byte[streamCheck.length];
            int unreadLength = this.getSource().read(streamCheckBuff);
            if (Arrays.equals(streamCheck, streamCheckBuff)) {
                this.isStream = !this.isStream;
                System.arraycopy(streamCheckBuff, 0, buffer, 0, EOF_STRING.length);
                unreadLength = -1;
            } else {
                this.getSource().unread(unreadLength);
                this.getSource().read(buffer);
                unreadLength = buffer.length - 1;
            }
            if (this.getSource().isEOF()) {
                this.getSource().seek(currentOffset + this.document.getHeader().getHeaderOffset());
                return this.getSource().getStreamLength();
            }
            if (unreadLength <= 0) continue;
            this.getSource().unread(unreadLength);
        }
        long result = this.getSource().getOffset() - 1L + (long)buffer.length;
        this.getSource().skip(EOF_STRING.length - 1);
        this.floatingBytesNumber = 0;
        this.isStreamEnd = false;
        int nextByte = this.getSource().read();
        if (BaseParser.isLF(nextByte)) {
            ++result;
            ++this.floatingBytesNumber;
            nextByte = this.getSource().peek();
        } else if (BaseParser.isCR(nextByte)) {
            ++result;
            ++this.floatingBytesNumber;
            nextByte = this.getSource().read();
            if (BaseParser.isLF(nextByte)) {
                ++result;
                ++this.floatingBytesNumber;
                nextByte = this.getSource().peek();
            }
        }
        if (nextByte == -1) {
            this.isStreamEnd = true;
        }
        this.getSource().seek(currentOffset + this.document.getHeader().getHeaderOffset());
        return result;
    }

    private boolean isEOFFound(byte[] buffer) throws IOException {
        if (!Arrays.equals(buffer, EOF_STRING)) {
            return false;
        }
        long pointer = this.getSource().getOffset();
        this.getSource().unread(2);
        int byteBeforeEOF = this.getSource().peek();
        while (!BaseParser.isLF(byteBeforeEOF) && !BaseParser.isCR(byteBeforeEOF)) {
            this.getSource().unread();
            byteBeforeEOF = this.getSource().peek();
            if (byteBeforeEOF == 32) continue;
            this.getSource().seek(pointer);
            return false;
        }
        this.getSource().seek(pointer);
        return true;
    }

    private void skipID() throws IOException {
        this.nextObject();
        this.objects.clear();
        this.flag = true;
    }
}

