/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.xmp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFExtensionSchemaProperty;
import org.verapdf.xmp.impl.VeraPDFXMPNode;
import org.verapdf.xmp.impl.XMPNode;
import org.verapdf.xmp.options.PropertyOptions;

public class VeraPDFExtensionSchemaDefinition {
    private static final String PROPERTY = "property";
    private static final String NAMESPACE_URI = "namespaceURI";
    private static final String PREFIX = "prefix";
    private static final String SCHEMA = "schema";
    private static final String PDFA_SCHEMA_PREFIX = "pdfaSchema";
    private final VeraPDFXMPNode xmpNode;

    public VeraPDFExtensionSchemaDefinition(VeraPDFXMPNode xmpNode) {
        this.xmpNode = xmpNode;
    }

    public List<VeraPDFExtensionSchemaProperty> getExtensionSchemaProperties() {
        if (this.xmpNode != null) {
            ArrayList<VeraPDFExtensionSchemaProperty> res = new ArrayList<VeraPDFExtensionSchemaProperty>();
            for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PROPERTY.equals(child.getName())) continue;
                if (!child.getOptions().isArray()) break;
                for (VeraPDFXMPNode node : child.getChildren()) {
                    res.add(new VeraPDFExtensionSchemaProperty(node));
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    public VeraPDFXMPNode getPropertiesNode() {
        if (this.xmpNode != null) {
            for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PROPERTY.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public void addExtensionSchemaProperty(VeraPDFExtensionSchemaProperty propertyDefinitionXMPNode) throws XMPException {
        if (this.xmpNode != null) {
            this.getPropertiesNode().getOriginalNode().addChild(propertyDefinitionXMPNode.getXmpNode());
        }
    }

    public String getNamespaceURI() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public String getPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public XMPNode getXmpNode() {
        return this.xmpNode.getOriginalNode();
    }

    public static VeraPDFExtensionSchemaDefinition createExtensionSchemaDefinitionNode(String schema, String namespaceURI, String prefix) throws XMPException {
        XMPNode node = new XMPNode("[]", "", new PropertyOptions(256), "rdf");
        node.addChild(new XMPNode("pdfaSchema:schema", schema, new PropertyOptions(0), PDFA_SCHEMA_PREFIX));
        node.addChild(new XMPNode("pdfaSchema:namespaceURI", namespaceURI, new PropertyOptions(0), PDFA_SCHEMA_PREFIX));
        node.addChild(new XMPNode("pdfaSchema:prefix", prefix, new PropertyOptions(0), PDFA_SCHEMA_PREFIX));
        node.addChild(new XMPNode("pdfaSchema:property", "", new PropertyOptions(1536), PDFA_SCHEMA_PREFIX));
        return new VeraPDFExtensionSchemaDefinition(VeraPDFXMPNode.fromXMPNode(node));
    }
}

