/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.Slice16;
import net.sf.saxon.str.Slice8;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.str.ZenoString;
import net.sf.saxon.z.IntIterator;

public final class UTF8Writer
extends Writer
implements UnicodeWriter {
    private static final int MIN_BUF_LEN = 32;
    private static final int DEFAULT_BUF_LEN = 4096;
    static final int SURR1_FIRST = 55296;
    static final int SURR1_LAST = 56319;
    static final int SURR2_FIRST = 56320;
    static final int SURR2_LAST = 57343;
    private OutputStream _out;
    private byte[] _outBuffer;
    private final int _outBufferLast;
    private int _outPtr;
    int _surrogate = 0;

    public UTF8Writer(OutputStream out) {
        this(out, 4096);
    }

    public UTF8Writer(OutputStream out, int bufferLength) {
        if (bufferLength < 32) {
            bufferLength = 32;
        }
        this._out = new BufferedOutputStream(out);
        this._outBuffer = new byte[bufferLength];
        this._outBufferLast = bufferLength - 4;
        this._outPtr = 0;
    }

    @Override
    public void close() throws IOException {
        if (this._out != null) {
            this._flushBuffer();
            this._outBuffer = null;
            this._out.close();
            this._out = null;
            if (this._surrogate != 0) {
                int code = this._surrogate;
                this._surrogate = 0;
                this.throwIllegal(code);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this._out.flush();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        assert (off + len <= cbuf.length);
        if (len < 2) {
            if (len == 1) {
                this.write(cbuf[off]);
            }
            return;
        }
        if (this._surrogate > 0) {
            char second = cbuf[off++];
            --len;
            this.write(this._convertSurrogate(second));
        }
        int outPtr = this._outPtr;
        byte[] outBuf = this._outBuffer;
        int outBufLast = this._outBufferLast;
        len += off;
        while (off < len) {
            int c;
            if (outPtr >= outBufLast) {
                this._out.write(outBuf, 0, outPtr);
                outPtr = 0;
            }
            if ((c = cbuf[off++]) < 128) {
                outBuf[outPtr++] = (byte)c;
                int maxInCount = len - off;
                int maxOutCount = outBufLast - outPtr;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += off;
                boolean continueOuter = false;
                while (true) {
                    if (off >= maxInCount) {
                        continueOuter = true;
                        break;
                    }
                    if ((c = cbuf[off++]) >= 128) break;
                    outBuf[outPtr++] = (byte)c;
                }
                if (continueOuter) continue;
            }
            if (c < 2048) {
                outBuf[outPtr++] = (byte)(0xC0 | c >> 6);
                outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                outBuf[outPtr++] = (byte)(0xE0 | c >> 12);
                outBuf[outPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
                outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._outPtr = outPtr;
                this.throwIllegal(c);
            }
            this._surrogate = c;
            if (off >= len) break;
            if ((c = this._convertSurrogate(cbuf[off++])) > 0x10FFFF) {
                this._outPtr = outPtr;
                this.throwIllegal(c);
            }
            outBuf[outPtr++] = (byte)(0xF0 | c >> 18);
            outBuf[outPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
            outBuf[outPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
        }
        this._outPtr = outPtr;
    }

    public void writeLatin1(byte[] bytes, int off, int len) throws IOException {
        assert (off + len <= bytes.length);
        int outPtr = this._outPtr;
        byte[] outBuf = this._outBuffer;
        int outBufLast = this._outBufferLast;
        len += off;
        while (off < len) {
            int c;
            if (outPtr >= outBufLast) {
                this._out.write(outBuf, 0, outPtr);
                outPtr = 0;
            }
            if ((c = bytes[off++] & 0xFF) < 128) {
                outBuf[outPtr++] = (byte)c;
                int maxInCount = len - off;
                int maxOutCount = outBufLast - outPtr;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += off;
                boolean continueOuter = false;
                while (true) {
                    if (off >= maxInCount) {
                        continueOuter = true;
                        break;
                    }
                    if ((c = bytes[off++] & 0xFF) >= 128) break;
                    outBuf[outPtr++] = (byte)c;
                }
                if (continueOuter) continue;
            }
            outBuf[outPtr++] = (byte)(0xC0 | c >> 6);
            outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
        }
        this._outPtr = outPtr;
    }

    @Override
    public void writeAscii(byte[] content) throws IOException {
        this.writeAscii(content, 0, content.length);
    }

    public void writeAscii(byte[] chars, int off, int len) throws IOException {
        int outPtr = this._outPtr;
        byte[] outBuf = this._outBuffer;
        int outBufLast = this._outBufferLast;
        while (len > 0) {
            if (outPtr >= outBufLast) {
                this._out.write(outBuf, 0, outPtr);
                outPtr = 0;
            }
            int available = outBufLast - outPtr;
            int count = Math.min(len, available);
            System.arraycopy(chars, off, outBuf, outPtr, count);
            outPtr += count;
            off += count;
            len -= count;
        }
        this._outPtr = outPtr;
    }

    @Override
    public void writeRepeatedAscii(byte ch, int repeat) throws IOException {
        int outPtr = this._outPtr;
        byte[] outBuf = this._outBuffer;
        int outBufLast = this._outBufferLast;
        while (repeat > 0) {
            if (outPtr >= outBufLast) {
                this._out.write(outBuf, 0, outPtr);
                outPtr = 0;
            }
            int available = outBufLast - outPtr;
            int count = Math.min(repeat, available);
            Arrays.fill(outBuf, outPtr, outPtr + count, ch);
            outPtr += count;
            repeat -= count;
        }
        this._outPtr = outPtr;
    }

    @Override
    public void writeCodePoint(int codepoint) throws IOException {
        this.write(codepoint);
    }

    @Override
    public void write(int c) throws IOException {
        if (this._surrogate > 0) {
            c = this._convertSurrogate(c);
        } else if (c >= 55296 && c <= 57343) {
            if (c > 56319) {
                this.throwIllegal(c);
            }
            this._surrogate = c;
            return;
        }
        if (this._outPtr >= this._outBufferLast) {
            this._flushBuffer();
        }
        if (c < 128) {
            this._outBuffer[this._outPtr++] = (byte)c;
        } else {
            int ptr = this._outPtr;
            if (c < 2048) {
                this._outBuffer[ptr++] = (byte)(0xC0 | c >> 6);
                this._outBuffer[ptr++] = (byte)(0x80 | c & 0x3F);
            } else if (c <= 65535) {
                this._outBuffer[ptr++] = (byte)(0xE0 | c >> 12);
                this._outBuffer[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outBuffer[ptr++] = (byte)(0x80 | c & 0x3F);
            } else {
                if (c > 0x10FFFF) {
                    this.throwIllegal(c);
                }
                this._outBuffer[ptr++] = (byte)(0xF0 | c >> 18);
                this._outBuffer[ptr++] = (byte)(0x80 | c >> 12 & 0x3F);
                this._outBuffer[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outBuffer[ptr++] = (byte)(0x80 | c & 0x3F);
            }
            this._outPtr = ptr;
        }
    }

    @Override
    public void write(UnicodeString chars) throws IOException {
        block2: {
            block6: {
                block7: {
                    block5: {
                        block4: {
                            block3: {
                                block1: {
                                    if (!(chars instanceof StringView) && !(chars instanceof BMPString)) break block1;
                                    this.write(chars.toString());
                                    break block2;
                                }
                                if (!(chars instanceof UnicodeChar)) break block3;
                                this.writeCodePoint(((UnicodeChar)chars).getCodepoint());
                                break block2;
                            }
                            if (!(chars instanceof ZenoString)) break block4;
                            ((ZenoString)chars).writeSegments(this);
                            break block2;
                        }
                        if (chars.getWidth() > 8) break block5;
                        this.writeWidth8OrLower(chars);
                        break block2;
                    }
                    if (chars.getWidth() != 16) break block6;
                    if (!(chars instanceof Twine16)) break block7;
                    this.write(((Twine16)chars).getCharArray());
                    break block2;
                }
                if (!(chars instanceof Slice16)) break block2;
                Slice16 s16 = (Slice16)chars;
                this.write(s16.getCharArray(), s16.getStart(), s16.getEnd() - s16.getStart());
                break block2;
            }
            IntIterator iter = chars.codePoints();
            while (iter.hasNext()) {
                this.write(iter.next());
            }
        }
    }

    private void writeWidth8OrLower(UnicodeString chars) throws IOException {
        block5: {
            block6: {
                int width;
                Slice8 s8;
                block7: {
                    block3: {
                        int width2;
                        block4: {
                            if (!(chars instanceof Twine8)) break block3;
                            width2 = chars.getWidth();
                            if (width2 != 7) break block4;
                            this.writeAscii(((Twine8)chars).getByteArray(), 0, chars.length32());
                            break block5;
                        }
                        if (width2 != 8) break block5;
                        this.writeLatin1(((Twine8)chars).getByteArray(), 0, chars.length32());
                        break block5;
                    }
                    if (!(chars instanceof Slice8)) break block6;
                    s8 = (Slice8)chars;
                    width = chars.getWidth();
                    if (width != 7) break block7;
                    this.writeAscii(s8.getByteArray(), s8.getStart(), s8.getEnd() - s8.getStart());
                    break block5;
                }
                if (width != 8) break block5;
                this.writeLatin1(s8.getByteArray(), s8.getStart(), s8.getEnd() - s8.getStart());
                break block5;
            }
            if (chars instanceof WhitespaceString) {
                ((WhitespaceString)chars).write(this);
            } else {
                IntIterator iter = chars.codePoints();
                while (iter.hasNext()) {
                    this.write(iter.next());
                }
            }
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(str.charAt(off));
            }
            return;
        }
        if (this._surrogate > 0) {
            char second = str.charAt(off++);
            --len;
            this.write(this._convertSurrogate(second));
        }
        int outPtr = this._outPtr;
        byte[] outBuf = this._outBuffer;
        int outBufLast = this._outBufferLast;
        len += off;
        while (off < len) {
            int[] result;
            char c;
            if (outPtr >= outBufLast) {
                this._out.write(outBuf, 0, outPtr);
                outPtr = 0;
            }
            if ((c = str.charAt(off++)) < '\u0080') {
                outBuf[outPtr++] = (byte)c;
                int maxInCount = len - off;
                int maxOutCount = outBufLast - outPtr;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += off;
                boolean continueOuter = false;
                while (true) {
                    if (off >= maxInCount) {
                        continueOuter = true;
                        break;
                    }
                    if ((c = str.charAt(off++)) >= '\u0080') break;
                    outBuf[outPtr++] = (byte)c;
                }
                if (continueOuter) continue;
            }
            if ((result = this.writeMultiByte(c, outBuf, outPtr, str, off, len)) == null) break;
            outPtr = result[0];
            off = result[1];
        }
        this._outPtr = outPtr;
    }

    private int[] writeMultiByte(int c, byte[] outBuf, int outPtr, String str, int off, int len) throws IOException {
        if (c < 2048) {
            outBuf[outPtr++] = (byte)(0xC0 | c >> 6);
            outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
        } else {
            if (c < 55296 || c > 57343) {
                outBuf[outPtr++] = (byte)(0xE0 | c >> 12);
                outBuf[outPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
                outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
                return new int[]{outPtr, off};
            }
            if (c > 56319) {
                this._outPtr = outPtr;
                this.throwIllegal(c);
            }
            this._surrogate = c;
            if (off >= len) {
                return null;
            }
            if ((c = this._convertSurrogate(str.charAt(off++))) > 0x10FFFF) {
                this._outPtr = outPtr;
                this.throwIllegal(c);
            }
            outBuf[outPtr++] = (byte)(0xF0 | c >> 18);
            outBuf[outPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
            outBuf[outPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            outBuf[outPtr++] = (byte)(0x80 | c & 0x3F);
        }
        return new int[]{outPtr, off};
    }

    private void _flushBuffer() throws IOException {
        if (this._outPtr > 0 && this._outBuffer != null) {
            this._out.write(this._outBuffer, 0, this._outPtr);
            this._outPtr = 0;
        }
    }

    private int _convertSurrogate(int secondPart) throws IOException {
        int firstPart = this._surrogate;
        this._surrogate = 0;
        if (secondPart < 56320 || secondPart > 57343) {
            throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(firstPart) + ", second 0x" + Integer.toHexString(secondPart) + "; illegal combination");
        }
        return 65536 + (firstPart - 55296 << 10) + (secondPart - 56320);
    }

    private void throwIllegal(int code) throws IOException {
        if (code > 0x10FFFF) {
            throw new IOException("Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (code >= 55296) {
            if (code <= 56319) {
                throw new IOException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")");
            }
            throw new IOException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")");
        }
        throw new IOException("Illegal character point (0x" + Integer.toHexString(code) + ") to output");
    }
}

