/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFADestOutputProfileRef;
import org.verapdf.gf.model.impl.arlington.GFADeviceNMixingHints;
import org.verapdf.gf.model.impl.arlington.GFAICCProfileStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASpectralData;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADestOutputProfileRef;
import org.verapdf.model.alayer.ADeviceNMixingHints;
import org.verapdf.model.alayer.AICCProfileStream;
import org.verapdf.model.alayer.AOutputIntents;
import org.verapdf.model.alayer.ASpectralData;

public class GFAOutputIntents
extends GFAObject
implements AOutputIntents {
    public GFAOutputIntents(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AOutputIntents");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "DestOutputProfile": {
                return this.getDestOutputProfile();
            }
            case "DestOutputProfileRef": {
                return this.getDestOutputProfileRef();
            }
            case "MixingHints": {
                return this.getMixingHints();
            }
            case "SpectralData": {
                return this.getSpectralData();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AICCProfileStream> getDestOutputProfile() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDestOutputProfile1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AICCProfileStream> getDestOutputProfile1_4() {
        COSObject object = this.getDestOutputProfileValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAICCProfileStream> list = new ArrayList<GFAICCProfileStream>(1);
            list.add(new GFAICCProfileStream((COSStream)object.getDirectBase(), this.baseObject, "DestOutputProfile"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADestOutputProfileRef> getDestOutputProfileRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getDestOutputProfileRef2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ADestOutputProfileRef> getDestOutputProfileRef2_0() {
        COSObject object = this.getDestOutputProfileRefValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADestOutputProfileRef> list = new ArrayList<GFADestOutputProfileRef>(1);
            list.add(new GFADestOutputProfileRef((COSDictionary)object.getDirectBase(), this.baseObject, "DestOutputProfileRef"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADeviceNMixingHints> getMixingHints() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getMixingHints2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ADeviceNMixingHints> getMixingHints2_0() {
        COSObject object = this.getMixingHintsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADeviceNMixingHints> list = new ArrayList<GFADeviceNMixingHints>(1);
            list.add(new GFADeviceNMixingHints((COSDictionary)object.getDirectBase(), this.baseObject, "MixingHints"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASpectralData> getSpectralData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSpectralData2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ASpectralData> getSpectralData2_0() {
        COSObject object = this.getSpectralDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASpectralData> list = new ArrayList<GFASpectralData>(1);
            list.add(new GFASpectralData((COSDictionary)object.getDirectBase(), this.baseObject, "SpectralData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDestOutputProfile() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DestOutputProfile"));
    }

    public COSObject getDestOutputProfileValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DestOutputProfile"));
        return object;
    }

    @Override
    public Boolean getisDestOutputProfileIndirect() {
        COSObject DestOutputProfile = this.getDestOutputProfileValue();
        return GFAOutputIntents.getisIndirect(DestOutputProfile);
    }

    @Override
    public String getDestOutputProfileType() {
        COSObject DestOutputProfile = this.getDestOutputProfileValue();
        return this.getObjectType(DestOutputProfile);
    }

    @Override
    public Boolean getDestOutputProfileHasTypeStream() {
        COSObject DestOutputProfile = this.getDestOutputProfileValue();
        return GFAOutputIntents.getHasTypeStream(DestOutputProfile);
    }

    @Override
    public Boolean getcontainsDestOutputProfileRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DestOutputProfileRef"));
    }

    public COSObject getDestOutputProfileRefValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DestOutputProfileRef"));
        return object;
    }

    @Override
    public String getDestOutputProfileRefType() {
        COSObject DestOutputProfileRef = this.getDestOutputProfileRefValue();
        return this.getObjectType(DestOutputProfileRef);
    }

    @Override
    public Boolean getDestOutputProfileRefHasTypeDictionary() {
        COSObject DestOutputProfileRef = this.getDestOutputProfileRefValue();
        return GFAOutputIntents.getHasTypeDictionary(DestOutputProfileRef);
    }

    @Override
    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Info"));
        return object;
    }

    @Override
    public String getInfoType() {
        COSObject Info = this.getInfoValue();
        return this.getObjectType(Info);
    }

    @Override
    public Boolean getInfoHasTypeStringText() {
        COSObject Info = this.getInfoValue();
        return GFAOutputIntents.getHasTypeStringText(Info);
    }

    @Override
    public Boolean getcontainsMixingHints() {
        return this.baseObject.knownKey(ASAtom.getASAtom("MixingHints"));
    }

    public COSObject getMixingHintsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MixingHints"));
        return object;
    }

    @Override
    public String getMixingHintsType() {
        COSObject MixingHints = this.getMixingHintsValue();
        return this.getObjectType(MixingHints);
    }

    @Override
    public Boolean getMixingHintsHasTypeDictionary() {
        COSObject MixingHints = this.getMixingHintsValue();
        return GFAOutputIntents.getHasTypeDictionary(MixingHints);
    }

    @Override
    public Boolean getcontainsOutputCondition() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OutputCondition"));
    }

    public COSObject getOutputConditionValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OutputCondition"));
        return object;
    }

    @Override
    public String getOutputConditionType() {
        COSObject OutputCondition = this.getOutputConditionValue();
        return this.getObjectType(OutputCondition);
    }

    @Override
    public Boolean getOutputConditionHasTypeStringText() {
        COSObject OutputCondition = this.getOutputConditionValue();
        return GFAOutputIntents.getHasTypeStringText(OutputCondition);
    }

    @Override
    public Boolean getcontainsOutputConditionIdentifier() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OutputConditionIdentifier"));
    }

    public COSObject getOutputConditionIdentifierValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OutputConditionIdentifier"));
        return object;
    }

    @Override
    public String getOutputConditionIdentifierType() {
        COSObject OutputConditionIdentifier = this.getOutputConditionIdentifierValue();
        return this.getObjectType(OutputConditionIdentifier);
    }

    @Override
    public Boolean getOutputConditionIdentifierHasTypeStringText() {
        COSObject OutputConditionIdentifier = this.getOutputConditionIdentifierValue();
        return GFAOutputIntents.getHasTypeStringText(OutputConditionIdentifier);
    }

    @Override
    public Boolean getcontainsRegistryName() {
        return this.baseObject.knownKey(ASAtom.getASAtom("RegistryName"));
    }

    public COSObject getRegistryNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("RegistryName"));
        return object;
    }

    @Override
    public String getRegistryNameType() {
        COSObject RegistryName = this.getRegistryNameValue();
        return this.getObjectType(RegistryName);
    }

    @Override
    public Boolean getRegistryNameHasTypeStringText() {
        COSObject RegistryName = this.getRegistryNameValue();
        return GFAOutputIntents.getHasTypeStringText(RegistryName);
    }

    @Override
    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("S"));
        return object;
    }

    @Override
    public String getSType() {
        COSObject S = this.getSValue();
        return this.getObjectType(S);
    }

    @Override
    public Boolean getSHasTypeName() {
        COSObject S = this.getSValue();
        return GFAOutputIntents.getHasTypeName(S);
    }

    @Override
    public String getSNameValue() {
        COSObject S = this.getSValue();
        return GFAOutputIntents.getNameValue(S);
    }

    @Override
    public Boolean getcontainsSpectralData() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SpectralData"));
    }

    public COSObject getSpectralDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SpectralData"));
        return object;
    }

    @Override
    public String getSpectralDataType() {
        COSObject SpectralData = this.getSpectralDataValue();
        return this.getObjectType(SpectralData);
    }

    @Override
    public Boolean getSpectralDataHasTypeDictionary() {
        COSObject SpectralData = this.getSpectralDataValue();
        return GFAOutputIntents.getHasTypeDictionary(SpectralData);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAOutputIntents.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAOutputIntents.getNameValue(Type2);
    }
}

