/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa;

import java.util.List;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;

public abstract class AbstractFoundry
implements VeraPDFFoundry {
    static PDFAFlavour defaultFlavour = PDFAFlavour.ARLINGTON1_4;

    @Override
    public PDFAValidator createValidator(ValidatorConfig config) {
        if (config.getMaxFails() > 0) {
            return this.createFailFastValidator(config.getFlavour(), config.getMaxFails(), config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
        }
        return this.createValidator(config.getFlavour(), config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
    }

    @Override
    public PDFAValidator createValidator(ValidatorConfig config, PDFAFlavour flavour) {
        if (config.getMaxFails() > 0) {
            return this.createFailFastValidator(flavour, config.getMaxFails(), config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
        }
        return this.createValidator(flavour, config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
    }

    @Override
    public PDFAValidator createValidator(ValidatorConfig config, List<PDFAFlavour> flavours) {
        if (config.getMaxFails() > 0) {
            return this.createFailFastValidator(flavours, config.getMaxFails(), config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
        }
        return this.createValidator(flavours, config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
    }

    @Override
    public PDFAValidator createValidator(ValidatorConfig config, ValidationProfile profile) {
        if (config.getMaxFails() > 0) {
            return this.createFailFastValidator(profile, config.getMaxFails(), config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
        }
        return this.createValidator(profile, config.getMaxNumberOfDisplayedFailedChecks(), config.isRecordPasses(), config.showErrorMessages(), config.getShowProgress());
    }

    @Override
    public PDFAValidator createValidator(List<PDFAFlavour> flavours) {
        return ValidatorFactory.createValidator(flavours);
    }

    @Override
    public PDFAValidator createValidator(PDFAFlavour flavour, boolean logSuccess) {
        return ValidatorFactory.createValidator(flavour, logSuccess);
    }

    @Override
    public PDFAValidator createValidator(ValidationProfile profile, boolean logSuccess) {
        return ValidatorFactory.createValidator(profile, logSuccess);
    }

    @Override
    public PDFAValidator createValidator(PDFAFlavour flavour, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidator(flavour, maxNumberOfDisplayedFailedChecks, logSuccess, showErrorMessages, showProgress);
    }

    @Override
    public PDFAValidator createValidator(List<PDFAFlavour> flavours, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidatorByFlavours(flavours, maxNumberOfDisplayedFailedChecks, logSuccess, showErrorMessages, showProgress);
    }

    @Override
    public PDFAValidator createValidator(ValidationProfile profile, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidator(profile, maxNumberOfDisplayedFailedChecks, logSuccess, showErrorMessages, showProgress);
    }

    @Override
    public PDFAValidator createFailFastValidator(PDFAFlavour flavour, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidator(flavour, logSuccess, maxFailures, maxNumberOfDisplayedFailedChecks, showErrorMessages, showProgress);
    }

    @Override
    public PDFAValidator createFailFastValidator(List<PDFAFlavour> flavours, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidator(flavours, logSuccess, maxFailures, maxNumberOfDisplayedFailedChecks, showErrorMessages, showProgress);
    }

    @Override
    public PDFAValidator createFailFastValidator(ValidationProfile profile, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean logSuccess, boolean showErrorMessages, boolean showProgress) {
        return ValidatorFactory.createValidator(profile, logSuccess, maxFailures, maxNumberOfDisplayedFailedChecks, showErrorMessages, showProgress);
    }

    @Override
    public PDFAFlavour defaultFlavour() {
        return defaultFlavour;
    }

    @Override
    public void close() {
    }
}

