/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.BaseValidator;
import org.verapdf.pdfa.validation.validators.FastFailValidator;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorConfigImpl;

public final class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks);
    }

    public static PDFAValidator createValidator(List<PDFAFlavour> flavours) {
        if (flavours == null) {
            throw new IllegalArgumentException("Parameter (List<PDFAFlavour> flavours) cannot be null.");
        }
        return new BaseValidator(Profiles.getVeraProfileDirectory().getValidationProfilesByFlavours(flavours));
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidatorByFlavours(List<PDFAFlavour> flavours, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        if (flavours == null) {
            throw new IllegalArgumentException("Parameter (List<PDFAFlavour> flavour) cannot be null.");
        }
        return ValidatorFactory.createValidatorByProfiles(Profiles.getVeraProfileDirectory().getValidationProfilesByFlavours(flavours), maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks, int maxFailures) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks, maxFailures);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, boolean showProgress) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks, maxFailures, maxNumberOfDisplayedFailedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidator(List<PDFAFlavour> flavours, boolean logPassedChecks, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, boolean showProgress) {
        if (flavours == null) {
            throw new IllegalArgumentException("Parameter (List<PDFAFlavour> flavours) cannot be null.");
        }
        return ValidatorFactory.createValidatorByProfiles(Profiles.getVeraProfileDirectory().getValidationProfilesByFlavours(flavours), logPassedChecks, maxFailures, maxNumberOfDisplayedFailedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidator(ValidationProfile profile) {
        return ValidatorFactory.createValidator(profile, false);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        return new BaseValidator(profile, logPassedChecks);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        return new BaseValidator(profile, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidator(List<ValidationProfile> profiles, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        if (profiles == null) {
            throw new IllegalArgumentException("Parameter (List<ValidationProfile> profiles) cannot be null.");
        }
        return new BaseValidator(profiles, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidatorByProfiles(List<ValidationProfile> profiles, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        if (profiles == null) {
            throw new IllegalArgumentException("Parameter (List<ValidationProfile> profiles) cannot be null.");
        }
        return new BaseValidator(profiles, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, int maxFailures, boolean showProgress) {
        return ValidatorFactory.createValidator(profile, false, maxFailures, 100, false, showProgress);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, int maxFailures, boolean showProgress) {
        return ValidatorFactory.createValidator(flavour, false, maxFailures, 100, false, showProgress);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks, int maxFailures) {
        return ValidatorFactory.createValidator(profile, logPassedChecks, maxFailures, 100, false, false);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, boolean showProgress) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        if (maxFailures > 0) {
            return new FastFailValidator(profile, logPassedChecks, maxFailures, showErrorMessages, showProgress, maxNumberOfDisplayedFailedChecks);
        }
        return ValidatorFactory.createValidator(profile, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static PDFAValidator createValidatorByProfiles(List<ValidationProfile> profiles, boolean logPassedChecks, int maxFailures, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, boolean showProgress) {
        if (profiles == null) {
            throw new IllegalArgumentException("Parameter (List<ValidationProfile> profiles) cannot be null.");
        }
        if (maxFailures > 0) {
            return new FastFailValidator(profiles, logPassedChecks, maxFailures, showErrorMessages, showProgress, maxNumberOfDisplayedFailedChecks);
        }
        return ValidatorFactory.createValidator(profiles, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    public static ValidatorConfig defaultConfig() {
        return ValidatorConfigImpl.defaultInstance();
    }

    public static ValidatorConfig createConfig(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug) {
        return ValidatorConfigImpl.fromValues(flavour, recordPasses, maxFails, debug, false, Level.WARNING, "", false);
    }

    public static ValidatorConfig createConfig(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, String password, boolean showProgress) {
        return ValidatorConfigImpl.fromValues(flavour, recordPasses, maxFails, debug, isLogsEnabled, loggingLevel, password, showProgress);
    }

    public static ValidatorConfig createConfig(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, String password, boolean showProgress, boolean nonPDFExtension, EnumSet<ExtensionObjectType> enabledExtensions) {
        return ValidatorConfigImpl.fromValues(flavour, defaultFlavour, recordPasses, maxFails, debug, isLogsEnabled, loggingLevel, maxNumberOfDisplayedFailedChecks, showErrorMessages, password, showProgress, nonPDFExtension, enabledExtensions);
    }

    public static ValidatorConfig createConfig(InputStream source) throws JAXBException {
        return (ValidatorConfig)XmlSerialiser.typeFromXml(ValidatorConfigImpl.class, source);
    }

    public static String configToXml(ValidatorConfig source) throws JAXBException {
        return XmlSerialiser.toXml(source, true, false);
    }

    public static void configToXml(ValidatorConfig source, OutputStream dest) throws JAXBException {
        XmlSerialiser.toXml(source, dest, true, false);
    }
}

