/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.optionalcontent;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.optionalcontent.PDOptionalContentProperties;

public class PDOCMDDictionary {
    private static final Logger LOGGER = Logger.getLogger(PDOCMDDictionary.class.getCanonicalName());

    public static boolean isVisibleOCMDByP(COSBase property, PDOptionalContentProperties optProperties) {
        COSObject ocgProperty = property.getKey(ASAtom.OCGS);
        if (ocgProperty == null || ocgProperty.getType() != COSObjType.COS_ARRAY) {
            return true;
        }
        COSArray ocgs = (COSArray)ocgProperty.getDirectBase();
        ASAtom pValue = property.getNameKey(ASAtom.P);
        for (COSObject obj : ocgs) {
            boolean isVisible = optProperties.isVisibleLayer(obj.getStringKey(ASAtom.NAME));
            if (isVisible) {
                if (pValue == null || ASAtom.ANY_ON.equals(pValue)) {
                    return true;
                }
                if (!ASAtom.ALL_OFF.equals(pValue)) continue;
                return false;
            }
            if (ASAtom.ALL_ON.equals(pValue)) {
                return false;
            }
            if (!ASAtom.ANY_OFF.equals(pValue)) continue;
            return true;
        }
        return ASAtom.ALL_OFF.equals(pValue) || ASAtom.ALL_ON.equals(pValue);
    }

    public static boolean isVisibleOCMD(COSBase property, PDOptionalContentProperties optProperties) {
        COSObject veProperty = property.getKey(ASAtom.VE);
        if (veProperty != null && veProperty.getType() == COSObjType.COS_ARRAY) {
            COSArray veArray = (COSArray)veProperty.getDirectBase();
            return PDOCMDDictionary.evaluateVE(veArray, optProperties);
        }
        return PDOCMDDictionary.isVisibleOCMDByP(property, optProperties);
    }

    private static boolean evaluateVE(COSArray expr, PDOptionalContentProperties optProperties) {
        if (expr.size() == 0) {
            return true;
        }
        COSBase first = expr.at(0).getDirectBase();
        if (first instanceof COSName) {
            ASAtom operator = first.getName();
            if (ASAtom.OR.equals(operator)) {
                for (int i = 1; i < expr.size(); ++i) {
                    if (!PDOCMDDictionary.evaluateOperandOfVE(expr.at(i).getDirectBase(), optProperties)) continue;
                    return true;
                }
                return false;
            }
            if (ASAtom.AND.equals(operator)) {
                for (int i = 1; i < expr.size(); ++i) {
                    if (PDOCMDDictionary.evaluateOperandOfVE(expr.at(i).getDirectBase(), optProperties)) continue;
                    return false;
                }
                return true;
            }
            if (ASAtom.NOT.equals(operator)) {
                if (expr.size() != 2) {
                    LOGGER.log(Level.WARNING, "/Not operator should have only 1 argument in VE array");
                    return true;
                }
                return !PDOCMDDictionary.evaluateOperandOfVE(expr.at(1).getDirectBase(), optProperties);
            }
            LOGGER.log(Level.WARNING, String.format("First element of VE array has value %s instead of /And, /Or or /Not", operator));
        } else {
            LOGGER.log(Level.WARNING, "First element of VE array should have type name");
        }
        return true;
    }

    private static boolean evaluateOperandOfVE(COSBase operand, PDOptionalContentProperties optProperties) {
        if (operand instanceof COSArray) {
            return PDOCMDDictionary.evaluateVE((COSArray)operand, optProperties);
        }
        if (operand instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)operand;
            String name = dict.getStringKey(ASAtom.NAME);
            return optProperties.isVisibleLayer(name);
        }
        return true;
    }
}

