/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLItemType;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class TypeAliasManager {
    private final Map<StructuredQName, ComponentDeclaration> unresolvedDeclarations = new HashMap<StructuredQName, ComponentDeclaration>();
    private final Map<StructuredQName, ItemType> typeAliases = new HashMap<StructuredQName, ItemType>();

    public void registerTypeAlias(StructuredQName name, ItemType type) {
        this.typeAliases.put(name, type);
        this.unresolvedDeclarations.remove(name);
    }

    public void processDeclaration(ComponentDeclaration declaration) throws XPathException {
        XSLItemType sta = (XSLItemType)declaration.getSourceElement();
        ItemType type = sta.tryToResolve();
        if (type != null) {
            this.registerTypeAlias(sta.getObjectName(), type);
        } else {
            this.unresolvedDeclarations.put(sta.getObjectName(), declaration);
        }
    }

    public void processAllDeclarations(List<ComponentDeclaration> topLevel) throws XPathException {
        for (ComponentDeclaration decl : topLevel) {
            if (!(decl.getSourceElement() instanceof XSLItemType)) continue;
            this.processDeclaration(decl);
        }
        int unresolved = this.unresolvedDeclarations.size();
        while (unresolved > 0) {
            HashSet<ComponentDeclaration> pending = new HashSet<ComponentDeclaration>(this.unresolvedDeclarations.values());
            for (ComponentDeclaration decl : pending) {
                this.processDeclaration(decl);
            }
            if (this.unresolvedDeclarations.size() >= unresolved) {
                StringBuilder fsb = new StringBuilder(256);
                fsb.append("Cannot resolve all type aliases, because of missing or circular definitions. Unresolved names: ");
                for (StructuredQName name : this.unresolvedDeclarations.keySet()) {
                    fsb.append(name.getDisplayName());
                    fsb.append(' ');
                }
                throw new XPathException(fsb.toString(), "SXTA0001");
            }
            unresolved = this.unresolvedDeclarations.size();
        }
    }

    public ItemType getItemType(StructuredQName alias) {
        return this.typeAliases.get(alias);
    }
}

