/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.FormXObjectFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class FormXObjectFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(FormXObjectFeaturesObject.class.getCanonicalName());
    private static final String ID = "id";
    private static final String XOBJECT = "xobject";
    private static final String FORM = "form";
    private static final String XOBJECT_XPATH = "xobject[@type='form']";
    private static final String TRANSPARENCY = "Transparency";

    public FormXObjectFeaturesObject(FormXObjectFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.FORM_XOBJECT;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        Long structParents;
        FormXObjectFeaturesObjectAdapter formAdapter = (FormXObjectFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(XOBJECT);
        root.setAttribute("type", FORM);
        String id = formAdapter.getId();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        double[] bBox = formAdapter.getBBox();
        CreateNodeHelper.addBoxFeature("bbox", bBox, root);
        CreateNodeHelper.addWidthHeightFeatures(bBox, root);
        CreateNodeHelper.parseMatrix(formAdapter.getMatrix(), root.addChild("matrix"));
        if (formAdapter.isGroupPresent()) {
            FeatureTreeNode groupNode = root.addChild("group");
            String groupSubtype = formAdapter.getGroupSubtype();
            CreateNodeHelper.addNotEmptyNode("subtype", groupSubtype, groupNode);
            if (TRANSPARENCY.equals(groupSubtype)) {
                String groupColorSpaceChild = formAdapter.getGroupColorSpaceChild();
                if (groupColorSpaceChild != null) {
                    FeatureTreeNode clr = groupNode.addChild("colorSpace");
                    clr.setAttribute(ID, groupColorSpaceChild);
                }
                groupNode.addChild("isolated").setValue(String.valueOf(formAdapter.isTransparencyGroupIsolated()));
                groupNode.addChild("knockout").setValue(String.valueOf(formAdapter.isTransparencyGroupKnockout()));
            }
        }
        if ((structParents = formAdapter.getStructParents()) != null) {
            root.addChild("structParents").setValue(String.valueOf(structParents));
        }
        try (InputStream is = formAdapter.getMetadataStream();){
            CreateNodeHelper.parseMetadata(is, "metadata", root, this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error while obtaining unfiltered metadata stream", e);
            this.registerNewError(e.getMessage());
        }
        this.parseResources(root);
        return root;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        FormXObjectFeaturesObjectAdapter formAdapter = (FormXObjectFeaturesObjectAdapter)this.adapter;
        Set<String> extGStateChild = formAdapter.getExtGStateChild();
        Set<String> colorSpaceChild = formAdapter.getColorSpaceChild();
        Set<String> patternChild = formAdapter.getPatternChild();
        Set<String> shadingChild = formAdapter.getShadingChild();
        Set<String> xobjectChild = formAdapter.getXObjectChild();
        Set<String> fontChild = formAdapter.getFontChild();
        Set<String> propertiesChild = formAdapter.getPropertiesChild();
        if (extGStateChild != null && !extGStateChild.isEmpty() || colorSpaceChild != null && !colorSpaceChild.isEmpty() || patternChild != null && !patternChild.isEmpty() || shadingChild != null && !shadingChild.isEmpty() || xobjectChild != null && !xobjectChild.isEmpty() || fontChild != null && !fontChild.isEmpty() || propertiesChild != null && !propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            CreateNodeHelper.parseIDSet(extGStateChild, "graphicsState", "graphicsStates", resources);
            CreateNodeHelper.parseIDSet(colorSpaceChild, "colorSpace", "colorSpaces", resources);
            CreateNodeHelper.parseIDSet(patternChild, "pattern", "patterns", resources);
            CreateNodeHelper.parseIDSet(shadingChild, "shading", "shadings", resources);
            CreateNodeHelper.parseIDSet(xobjectChild, XOBJECT, "xobjects", resources);
            CreateNodeHelper.parseIDSet(fontChild, "font", "fonts", resources);
            CreateNodeHelper.parseIDSet(propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Width", FormXObjectFeaturesObject.generateVariableXPath(XOBJECT_XPATH, "width"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Height", FormXObjectFeaturesObject.generateVariableXPath(XOBJECT_XPATH, "height"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Error IDs", FormXObjectFeaturesObject.generateAttributeXPath(XOBJECT_XPATH, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

