/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.verapdf.component.AuditDurationImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ReportParserEventHandler
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(ReportParserEventHandler.class.getCanonicalName());
    private static final Set<String> BATCH_SUMMARY_TAGS = new HashSet<String>(Arrays.asList("batchSummary", "arlingtonReports", "featureReports", "repairReports"));
    private String element;
    private final Map<String, Map<String, Integer>> batchSummary = new LinkedHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Integer>> current = new LinkedHashMap<String, Map<String, Integer>>();
    private boolean isPrinting = false;
    private final long startTime;
    private boolean isAddReportToSummary = false;
    private final XMLStreamWriter writer;

    public ReportParserEventHandler(XMLStreamWriter writer) {
        this.writer = writer;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void endDocument() {
        if (!this.current.isEmpty()) {
            if (!this.batchSummary.isEmpty()) {
                this.current.forEach((k, currentAttributesAndValues) -> {
                    Map<String, Integer> summaryAttributesAndValues = this.batchSummary.get(k);
                    currentAttributesAndValues.forEach((key, v) -> summaryAttributesAndValues.merge((String)key, (Integer)v, Integer::sum));
                });
            } else {
                this.batchSummary.putAll(this.current);
            }
            this.current.clear();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.isAddReportToSummary && BATCH_SUMMARY_TAGS.contains(qName) && !this.current.containsKey(qName)) {
            this.addReportToSummary(qName, attributes);
        }
        if (this.element.equals(qName)) {
            this.isPrinting = true;
        }
        if (this.isPrinting) {
            this.print(qName, attributes);
        }
    }

    private void print(String qName, Attributes attributes) {
        try {
            this.writer.writeStartElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.writer.writeAttribute(attributes.getQName(i), attributes.getValue(i));
            }
        }
        catch (XMLStreamException e) {
            LOGGER.log(Level.SEVERE, "Can't write the element", e);
        }
    }

    private void addReportToSummary(String qName, Attributes attributes) {
        LinkedHashMap<String, Integer> attributesAndValues = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attribute = attributes.getQName(i);
            Integer value = Integer.valueOf(attributes.getValue(i));
            attributesAndValues.put(attribute, value);
        }
        this.current.put(qName, attributesAndValues);
    }

    public void printSummary() {
        try {
            String batchSummaryTag = "batchSummary";
            this.writeStartBatchSummaryTag(batchSummaryTag);
            this.batchSummary.remove(batchSummaryTag);
            this.writeTagsInsideBatchSummary(this.batchSummary.keySet());
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            LOGGER.log(Level.SEVERE, "Can't write the element", e);
        }
    }

    private void writeTagsInsideBatchSummary(Set<String> batchSummaryTags) throws XMLStreamException {
        batchSummaryTags.forEach(k -> {
            try {
                this.writer.writeStartElement((String)k);
                Map<String, Integer> attributesAndValues = this.batchSummary.get(k);
                int sum = attributesAndValues.values().stream().mapToInt(Number::intValue).sum();
                attributesAndValues.forEach((attribute, value) -> {
                    try {
                        this.writer.writeAttribute((String)attribute, String.valueOf(attributesAndValues.get(attribute)));
                    }
                    catch (XMLStreamException e) {
                        LOGGER.log(Level.SEVERE, "Can't write the element", e);
                    }
                });
                this.writer.writeCharacters(String.valueOf(sum));
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.SEVERE, "Can't write the element", e);
            }
        });
        this.writeDurationTag();
    }

    private void writeDurationTag() throws XMLStreamException {
        long finishTime = System.currentTimeMillis();
        String stringDuration = AuditDurationImpl.getStringDuration(finishTime - this.startTime);
        this.writer.writeStartElement("duration");
        this.writer.writeAttribute("start", String.valueOf(this.startTime));
        this.writer.writeAttribute("finish", String.valueOf(finishTime));
        this.writer.writeCharacters(stringDuration);
        this.writer.writeEndElement();
    }

    private void writeStartBatchSummaryTag(String batchSummaryTag) throws XMLStreamException {
        this.writer.writeStartElement(batchSummaryTag);
        Map<String, Integer> batchSummaryAttributesAndValues = this.batchSummary.get(batchSummaryTag);
        batchSummaryAttributesAndValues.forEach((attribute, value) -> {
            try {
                this.writer.writeAttribute((String)attribute, String.valueOf(value));
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.SEVERE, "Can't write the element", e);
            }
        });
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.isPrinting) {
            try {
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.SEVERE, "Can't write the element", e);
            }
        }
        if (this.element.equals(qName)) {
            this.isPrinting = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.isPrinting) {
            try {
                this.writer.writeCharacters(new String(ch, start, length));
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.SEVERE, "Can't write the element", e);
            }
        }
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setIsAddReportToSummary(boolean addReportToSummary) {
        this.isAddReportToSummary = addReportToSummary;
    }
}

