/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.processor.TaskType;

public enum ProcessType {
    VALIDATE("Arlington PDF Model check", EnumSet.of(TaskType.VALIDATE)),
    FIX("fix", EnumSet.of(TaskType.VALIDATE, TaskType.FIX_METADATA)),
    EXTRACT("PDF Features", EnumSet.of(TaskType.EXTRACT_FEATURES)),
    VALIDATE_EXTRACT("Arlington and Features", EnumSet.of(TaskType.VALIDATE, TaskType.EXTRACT_FEATURES)),
    EXTRACT_FIX("extract and fix", EnumSet.of(TaskType.VALIDATE, TaskType.FIX_METADATA, TaskType.EXTRACT_FEATURES)),
    POLICY("Policy", EnumSet.of(TaskType.VALIDATE, TaskType.EXTRACT_FEATURES)),
    POLICY_FIX("policy and fix", EnumSet.of(TaskType.VALIDATE, TaskType.FIX_METADATA, TaskType.EXTRACT_FEATURES)),
    NO_PROCESS("", EnumSet.noneOf(TaskType.class));

    private static final Logger logger;
    private final EnumSet<TaskType> tasks;
    private final String value;

    private ProcessType(String value, EnumSet<TaskType> tasks) {
        this.value = value;
        this.tasks = EnumSet.copyOf(tasks);
    }

    public EnumSet<TaskType> getTasks() {
        return this.tasks;
    }

    public String getValue() {
        return this.value;
    }

    public static ProcessType addProcess(ProcessType base, ProcessType toAdd) {
        if (base == NO_PROCESS) {
            return toAdd;
        }
        if (toAdd == NO_PROCESS) {
            return base;
        }
        if (base == VALIDATE) {
            if (toAdd == EXTRACT) {
                return VALIDATE_EXTRACT;
            }
        } else if (base == EXTRACT) {
            if (toAdd == VALIDATE) {
                return VALIDATE_EXTRACT;
            }
            if (toAdd == FIX) {
                logger.log(Level.WARNING, "Incompatible process types: Features and Fix metadata.");
                return EXTRACT;
            }
        } else if (base == FIX) {
            if (toAdd == VALIDATE_EXTRACT) {
                return EXTRACT_FIX;
            }
            if (toAdd == EXTRACT) {
                logger.log(Level.WARNING, "Incompatible process types: Fix metadata and Features.");
                return FIX;
            }
            if (toAdd == POLICY) {
                return POLICY_FIX;
            }
        } else if (base == VALIDATE_EXTRACT) {
            if (toAdd == FIX) {
                return EXTRACT_FIX;
            }
        } else {
            if (base == EXTRACT_FIX) {
                if (toAdd == POLICY || toAdd == POLICY_FIX) {
                    return POLICY_FIX;
                }
                return EXTRACT_FIX;
            }
            if (base == POLICY) {
                if (toAdd == FIX || toAdd == EXTRACT_FIX) {
                    return POLICY_FIX;
                }
                return POLICY;
            }
            if (base == POLICY_FIX) {
                return POLICY_FIX;
            }
        }
        return toAdd;
    }

    public static ProcessType[] getOptionValues() {
        return new ProcessType[]{VALIDATE, EXTRACT, VALIDATE_EXTRACT, POLICY};
    }

    static {
        logger = Logger.getLogger(ProcessType.class.getCanonicalName());
    }
}

