/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.actions.PDFormFieldActions;
import org.verapdf.pd.form.PDSignatureField;

public class PDFormField
extends PDObject {
    private final Set<COSKey> parents;

    protected PDFormField(COSObject obj, Set<COSKey> parents) {
        super(obj);
        COSKey objectKey = obj.getObjectKey();
        this.parents = new HashSet<COSKey>(parents);
        if (objectKey != null) {
            if (this.parents.contains(objectKey)) {
                throw new LoopedException("Loop form field tree");
            }
            this.parents.add(objectKey);
        }
    }

    public static PDFormField createTypedFormField(COSObject obj) {
        return PDFormField.createTypedFormField(obj, new HashSet<COSKey>());
    }

    private static PDFormField createTypedFormField(COSObject obj, Set<COSKey> parents) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument object can not be null");
        }
        if (parents == null) {
            throw new IllegalArgumentException("Argument parents can not be null");
        }
        ASAtom fieldType = PDFormField.getFieldTypeCOSObject(obj);
        if (fieldType == ASAtom.SIG) {
            return new PDSignatureField(obj, parents);
        }
        return new PDFormField(obj, parents);
    }

    public ASAtom getFT() {
        COSObject object = this.getInheritedObject(ASAtom.FT);
        return object == null || object.getType() != COSObjType.COS_NAME ? null : object.getName();
    }

    public COSObject getV() {
        return this.getInheritedObject(ASAtom.V);
    }

    private COSObject getInheritedObject(ASAtom key) {
        COSObject currObject = this.getObject();
        HashSet<COSKey> checkedObjects = new HashSet<COSKey>();
        while (currObject != null) {
            COSObject parent;
            COSObject currVal = currObject.getKey(key);
            if (currVal != null && !currVal.empty()) {
                return currVal;
            }
            COSKey currKey = currObject.getKey();
            if (currKey != null) {
                checkedObjects.add(currKey);
            }
            if ((parent = currObject.getKey(ASAtom.PARENT)) != null && parent.getType().isDictionaryBased() && !checkedObjects.contains(parent.getKey())) {
                currObject = parent;
                continue;
            }
            currObject = null;
        }
        return null;
    }

    public String getFullyQualifiedName() {
        ArrayList<String> parts = new ArrayList<String>();
        COSObject currObject = this.getObject();
        HashSet<COSKey> checkedObjects = new HashSet<COSKey>();
        while (currObject != null && !currObject.empty()) {
            COSObject parent;
            COSKey currKey;
            String partial = currObject.getStringKey(ASAtom.T);
            if (partial != null) {
                parts.add(partial);
            }
            if ((currKey = currObject.getKey()) != null) {
                checkedObjects.add(currKey);
            }
            if ((parent = currObject.getKey(ASAtom.PARENT)) != null && parent.getType().isDictionaryBased() && !checkedObjects.contains(parent.getKey())) {
                currObject = parent;
                continue;
            }
            currObject = null;
        }
        if (!parts.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (int i = parts.size() - 1; i > 0; --i) {
                builder.append((String)parts.get(i)).append('.');
            }
            builder.append((String)parts.get(0));
            return builder.toString();
        }
        return null;
    }

    public PDFormFieldActions getActions() {
        COSObject object = this.getKey(ASAtom.AA);
        if (object != null && object.getType().isDictionaryBased()) {
            return new PDFormFieldActions(object);
        }
        return null;
    }

    public List<PDFormField> getChildFormFields() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && kids.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDFormField> res = new ArrayList<PDFormField>();
            for (COSObject elem : (COSArray)kids.getDirectBase()) {
                if (!PDFormField.isField(elem)) continue;
                res.add(PDFormField.createTypedFormField(elem, this.parents));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private static ASAtom getFieldTypeCOSObject(COSObject field) {
        ASAtom res = field.getNameKey(ASAtom.FT);
        if (res != null) {
            return res;
        }
        COSObject parent = field.getKey(ASAtom.PARENT);
        if (parent != null) {
            return PDFormField.getFieldTypeCOSObject(parent);
        }
        return null;
    }

    public String getTU() {
        return this.getStringKey(ASAtom.TU);
    }

    public Long getFf() {
        return this.getIntegerKey(ASAtom.FF);
    }

    public Long getStructParent() {
        return this.getIntegerKey(ASAtom.STRUCT_PARENT);
    }

    public static boolean isField(COSObject obj) {
        return obj != null && !obj.empty() && obj.knownKey(ASAtom.T) != false;
    }
}

