/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_4ColourSpaceEntries;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DRenderMode;
import org.verapdf.model.alayer.AArrayOf_4ColourSpaceEntries;
import org.verapdf.model.baselayer.Object;

public class GFA3DRenderMode
extends GFAObject
implements A3DRenderMode {
    public GFA3DRenderMode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DRenderMode");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "AC": {
                return this.getAC();
            }
            case "FC": {
                return this.getFC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf_4ColourSpaceEntries> getAC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAC1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getAC1_7() {
        COSObject object = this.getACValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4ColourSpaceEntries> list = new ArrayList<GFAArrayOf_4ColourSpaceEntries>(1);
            list.add(new GFAArrayOf_4ColourSpaceEntries((COSArray)object.getDirectBase(), this.baseObject, "AC"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getFC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFC1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getFC1_7() {
        COSObject object = this.getFCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4ColourSpaceEntries> list = new ArrayList<GFAArrayOf_4ColourSpaceEntries>(1);
            list.add(new GFAArrayOf_4ColourSpaceEntries((COSArray)object.getDirectBase(), this.baseObject, "FC"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AC"));
    }

    public COSObject getACValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AC"));
        return object;
    }

    @Override
    public String getACType() {
        COSObject AC = this.getACValue();
        return this.getObjectType(AC);
    }

    @Override
    public Boolean getACHasTypeArray() {
        COSObject AC = this.getACValue();
        return GFA3DRenderMode.getHasTypeArray(AC);
    }

    @Override
    public Boolean getcontainsCV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CV"));
    }

    public COSObject getCVDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSReal.construct(45.0);
            }
        }
        return null;
    }

    public COSObject getCVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CV"));
        if (object == null || object.empty()) {
            object = this.getCVDefaultValue();
        }
        return object;
    }

    @Override
    public String getCVType() {
        COSObject CV = this.getCVValue();
        return this.getObjectType(CV);
    }

    @Override
    public Boolean getCVHasTypeNumber() {
        COSObject CV = this.getCVValue();
        return GFA3DRenderMode.getHasTypeNumber(CV);
    }

    @Override
    public Boolean getcontainsFC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FC"));
    }

    public COSObject getFCDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("BG");
            }
        }
        return null;
    }

    public COSObject getFCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FC"));
        if (object == null || object.empty()) {
            object = this.getFCDefaultValue();
        }
        return object;
    }

    @Override
    public String getFCType() {
        COSObject FC = this.getFCValue();
        return this.getObjectType(FC);
    }

    @Override
    public Boolean getFCHasTypeArray() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getHasTypeArray(FC);
    }

    @Override
    public Boolean getFCHasTypeName() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getHasTypeName(FC);
    }

    @Override
    public String getFCNameValue() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getNameValue(FC);
    }

    @Override
    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom("O"));
    }

    public COSObject getODefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSReal.construct(0.5);
            }
        }
        return null;
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("O"));
        if (object == null || object.empty()) {
            object = this.getODefaultValue();
        }
        return object;
    }

    @Override
    public String getOType() {
        COSObject O = this.getOValue();
        return this.getObjectType(O);
    }

    @Override
    public Boolean getOHasTypeNumber() {
        COSObject O = this.getOValue();
        return GFA3DRenderMode.getHasTypeNumber(O);
    }

    @Override
    public Double getONumberValue() {
        COSObject O = this.getOValue();
        return GFA3DRenderMode.getNumberValue(O);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DRenderMode.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DRenderMode.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DRenderMode.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DRenderMode.getNameValue(Type2);
    }
}

