/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAOptContentMembership;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImage;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AAlternateImage;
import org.verapdf.model.alayer.AXObjectImage;
import org.verapdf.model.baselayer.Object;

public class GFAAlternateImage
extends GFAObject
implements AAlternateImage {
    public GFAAlternateImage(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAlternateImage");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Image": {
                return this.getImage();
            }
            case "OC": {
                return this.getOC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXObjectImage> getImage() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getImage1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AXObjectImage> getImage1_3() {
        COSObject object = this.getImageValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXObjectImage> list = new ArrayList<GFAXObjectImage>(1);
            list.add(new GFAXObjectImage((COSStream)object.getDirectBase(), this.baseObject, "Image"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getOC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getOC1_5() {
        COSObject object = this.getOCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getOCDictionary1_5(object.getDirectBase(), "OC");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getOCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "OCG": {
                return new GFAOptContentGroup(base, this.baseObject, keyName);
            }
            case "OCMD": {
                return new GFAOptContentMembership(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    @Override
    public Boolean getcontainsDefaultForPrinting() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefaultForPrinting"));
    }

    public COSObject getDefaultForPrintingDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getDefaultForPrintingValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefaultForPrinting"));
        if (object == null || object.empty()) {
            object = this.getDefaultForPrintingDefaultValue();
        }
        return object;
    }

    @Override
    public String getDefaultForPrintingType() {
        COSObject DefaultForPrinting = this.getDefaultForPrintingValue();
        return this.getObjectType(DefaultForPrinting);
    }

    @Override
    public Boolean getDefaultForPrintingHasTypeBoolean() {
        COSObject DefaultForPrinting = this.getDefaultForPrintingValue();
        return GFAAlternateImage.getHasTypeBoolean(DefaultForPrinting);
    }

    @Override
    public Boolean getcontainsImage() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Image"));
    }

    public COSObject getImageValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Image"));
        return object;
    }

    @Override
    public Boolean getisImageIndirect() {
        COSObject Image = this.getImageValue();
        return GFAAlternateImage.getisIndirect(Image);
    }

    @Override
    public String getImageType() {
        COSObject Image = this.getImageValue();
        return this.getObjectType(Image);
    }

    @Override
    public Boolean getImageHasTypeStream() {
        COSObject Image = this.getImageValue();
        return GFAAlternateImage.getHasTypeStream(Image);
    }

    @Override
    public Boolean getcontainsOC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OC"));
    }

    public COSObject getOCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OC"));
        return object;
    }

    @Override
    public String getOCType() {
        COSObject OC = this.getOCValue();
        return this.getObjectType(OC);
    }

    @Override
    public Boolean getOCHasTypeDictionary() {
        COSObject OC = this.getOCValue();
        return GFAAlternateImage.getHasTypeDictionary(OC);
    }
}

