/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStreamsGeneral;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStreamsGeneral;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AVRI;
import org.verapdf.model.baselayer.Object;

public class GFAVRI
extends GFAObject
implements AVRI {
    public GFAVRI(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AVRI");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CRL": {
                return this.getCRL();
            }
            case "Cert": {
                return this.getCert();
            }
            case "OCSP": {
                return this.getOCSP();
            }
            case "TS": {
                return this.getTS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStreamsGeneral> getCRL() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCRL1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCRL1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCRL1_7() {
        COSObject object = this.getCRLValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "CRL"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCert1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCert1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert1_7() {
        COSObject object = this.getCertValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "Cert"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getOCSP1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getOCSP1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP1_7() {
        COSObject object = this.getOCSPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "OCSP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getTS1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS1_7() {
        COSObject object = this.getTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "TS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCRL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CRL"));
    }

    public COSObject getCRLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CRL"));
        return object;
    }

    @Override
    public String getCRLType() {
        COSObject CRL = this.getCRLValue();
        return this.getObjectType(CRL);
    }

    @Override
    public Boolean getCRLHasTypeArray() {
        COSObject CRL = this.getCRLValue();
        return GFAVRI.getHasTypeArray(CRL);
    }

    @Override
    public Long getCRLArraySize() {
        COSObject CRL = this.getCRLValue();
        return GFAVRI.getArraySize(CRL);
    }

    @Override
    public Boolean getcontainsCert() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Cert"));
    }

    public COSObject getCertValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Cert"));
        return object;
    }

    @Override
    public String getCertType() {
        COSObject Cert = this.getCertValue();
        return this.getObjectType(Cert);
    }

    @Override
    public Boolean getCertHasTypeArray() {
        COSObject Cert = this.getCertValue();
        return GFAVRI.getHasTypeArray(Cert);
    }

    @Override
    public Long getCertArraySize() {
        COSObject Cert = this.getCertValue();
        return GFAVRI.getArraySize(Cert);
    }

    @Override
    public Boolean getcontainsOCSP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OCSP"));
    }

    public COSObject getOCSPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OCSP"));
        return object;
    }

    @Override
    public String getOCSPType() {
        COSObject OCSP = this.getOCSPValue();
        return this.getObjectType(OCSP);
    }

    @Override
    public Boolean getOCSPHasTypeArray() {
        COSObject OCSP = this.getOCSPValue();
        return GFAVRI.getHasTypeArray(OCSP);
    }

    @Override
    public Long getOCSPArraySize() {
        COSObject OCSP = this.getOCSPValue();
        return GFAVRI.getArraySize(OCSP);
    }

    @Override
    public Boolean getcontainsTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("TS"));
    }

    public COSObject getTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("TS"));
        return object;
    }

    @Override
    public Boolean getisTSIndirect() {
        COSObject TS = this.getTSValue();
        return GFAVRI.getisIndirect(TS);
    }

    @Override
    public String getTSType() {
        COSObject TS = this.getTSValue();
        return this.getObjectType(TS);
    }

    @Override
    public Boolean getTSHasTypeStream() {
        COSObject TS = this.getTSValue();
        return GFAVRI.getHasTypeStream(TS);
    }

    @Override
    public Boolean getcontainsTU() {
        return this.baseObject.knownKey(ASAtom.getASAtom("TU"));
    }

    public COSObject getTUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("TU"));
        return object;
    }

    @Override
    public String getTUType() {
        COSObject TU = this.getTUValue();
        return this.getObjectType(TU);
    }

    @Override
    public Boolean getTUHasTypeDate() {
        COSObject TU = this.getTUValue();
        return GFAVRI.getHasTypeDate(TU);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAVRI.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAVRI.getNameValue(Type2);
    }

    public COSObject getparentCRLsValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject CRLs = this.parentObject.getKey(ASAtom.getASAtom("CRLs"));
        return CRLs;
    }

    public COSObject getparentOCSPsValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject OCSPs = this.parentObject.getKey(ASAtom.getASAtom("OCSPs"));
        return OCSPs;
    }

    @Override
    public Long getparentCRLsArraySize() {
        COSObject parentCRLs = this.getparentCRLsValue();
        return GFAVRI.getArraySize(parentCRLs);
    }

    @Override
    public Long getparentOCSPsArraySize() {
        COSObject parentOCSPs = this.getparentOCSPsValue();
        return GFAVRI.getArraySize(parentOCSPs);
    }

    @Override
    public Boolean getparentCRLsHasTypeArray() {
        COSObject parentCRLs = this.getparentCRLsValue();
        return GFAVRI.getHasTypeArray(parentCRLs);
    }

    @Override
    public Boolean getparentOCSPsHasTypeArray() {
        COSObject parentOCSPs = this.getparentOCSPsValue();
        return GFAVRI.getHasTypeArray(parentOCSPs);
    }
}

