/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.CIDWArrayRange;

public class CIDWArray {
    private static final Logger LOGGER = Logger.getLogger(CIDWArray.class.getCanonicalName());
    private final Map<Integer, Double> singleMappings = new HashMap<Integer, Double>();
    private final List<CIDWArrayRange> ranges = new ArrayList<CIDWArrayRange>();

    public CIDWArray(COSArray w) {
        if (w != null) {
            for (int i = 0; i < w.size(); ++i) {
                int cidBegin = w.at(i++).getInteger().intValue();
                COSObject obj = w.at(i);
                if (obj.getType() == COSObjType.COS_INTEGER) {
                    Double width;
                    int cidEnd = obj.getInteger().intValue();
                    if ((width = w.at(++i).getReal()) == null) {
                        LOGGER.log(Level.FINE, "Unexpected end of W array in CID font");
                        return;
                    }
                    this.ranges.add(new CIDWArrayRange(cidBegin, cidEnd, width));
                    continue;
                }
                if (obj.getType() != COSObjType.COS_ARRAY) continue;
                this.addSingleMappings(cidBegin, (COSArray)obj.getDirectBase());
            }
        }
    }

    private void addSingleMappings(int cidBegin, COSArray arr) {
        for (int i = 0; i < arr.size(); ++i) {
            if (!arr.at(i).getType().isNumber()) {
                LOGGER.log(Level.SEVERE, "W array in CIDFont has invalid entry.");
                continue;
            }
            this.singleMappings.put(cidBegin + i, arr.at(i).getReal());
        }
    }

    public Double getWidth(int cid) {
        Double res = this.singleMappings.get(cid);
        if (res == null) {
            for (CIDWArrayRange range : this.ranges) {
                if (!range.contains(cid)) continue;
                res = range.getWidth();
                break;
            }
        }
        return res;
    }
}

