/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.ShadingFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ShadingFeaturesObject
extends FeaturesObject {
    private static final String ID = "id";
    private static final String SHADING = "shading";
    private static final String SHADING_TYPE = "shadingType";
    private static final String ANTI_ALIAS = "antiAlias";

    public ShadingFeaturesObject(ShadingFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.SHADING;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        ShadingFeaturesObjectAdapter shadingAdapter = (ShadingFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(SHADING);
        String id = shadingAdapter.getID();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        root.addChild(SHADING_TYPE).setValue(String.valueOf(shadingAdapter.getShadingType()));
        String colorSpaceChild = shadingAdapter.getColorSpaceChild();
        if (colorSpaceChild != null) {
            FeatureTreeNode shadingClr = root.addChild("colorSpace");
            shadingClr.setAttribute(ID, colorSpaceChild);
        }
        CreateNodeHelper.addBoxFeature("bbox", shadingAdapter.getBBox(), root);
        root.addChild(ANTI_ALIAS).setValue(String.valueOf(shadingAdapter.getAntiAlias()));
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Shading Type", ShadingFeaturesObject.generateVariableXPath(SHADING, SHADING_TYPE), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Anti Alias", ShadingFeaturesObject.generateVariableXPath(SHADING, ANTI_ALIAS), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Error IDs", ShadingFeaturesObject.generateAttributeXPath(SHADING, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

