/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.arlington.GFAWebCaptureCommandSettings;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AWebCaptureCommand;
import org.verapdf.model.alayer.AWebCaptureCommandSettings;

public class GFAWebCaptureCommand
extends GFAObject
implements AWebCaptureCommand {
    public GFAWebCaptureCommand(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AWebCaptureCommand");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "P": {
                return this.getP();
            }
            case "S": {
                return this.getS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getP1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getP1_3() {
        COSObject object = this.getPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "P"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommandSettings> getS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getS1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommandSettings> getS1_3() {
        COSObject object = this.getSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAWebCaptureCommandSettings> list = new ArrayList<GFAWebCaptureCommandSettings>(1);
            list.add(new GFAWebCaptureCommandSettings((COSDictionary)object.getDirectBase(), this.baseObject, "S"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCT() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CT"));
    }

    public COSObject getCTDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSString.construct("application/x-www-form-urlencoded".getBytes());
            }
        }
        return null;
    }

    public COSObject getCTValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CT"));
        if (object == null || object.empty()) {
            object = this.getCTDefaultValue();
        }
        return object;
    }

    @Override
    public String getCTType() {
        COSObject CT = this.getCTValue();
        return this.getObjectType(CT);
    }

    @Override
    public Boolean getCTHasTypeStringAscii() {
        COSObject CT = this.getCTValue();
        return GFAWebCaptureCommand.getHasTypeStringAscii(CT);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct(0L);
            }
        }
        return null;
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        if (object == null || object.empty()) {
            object = this.getFDefaultValue();
        }
        return object;
    }

    @Override
    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    @Override
    public Boolean getFHasTypeBitmask() {
        COSObject F = this.getFValue();
        return GFAWebCaptureCommand.getHasTypeBitmask(F);
    }

    @Override
    public Long getFBitmaskValue() {
        COSObject F = this.getFValue();
        return GFAWebCaptureCommand.getBitmaskValue(F);
    }

    @Override
    public Boolean getcontainsH() {
        return this.baseObject.knownKey(ASAtom.getASAtom("H"));
    }

    public COSObject getHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("H"));
        return object;
    }

    @Override
    public String getHType() {
        COSObject H = this.getHValue();
        return this.getObjectType(H);
    }

    @Override
    public Boolean getHHasTypeString() {
        COSObject H = this.getHValue();
        return GFAWebCaptureCommand.getHasTypeString(H);
    }

    @Override
    public Boolean getcontainsL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("L"));
    }

    public COSObject getLDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct(1L);
            }
        }
        return null;
    }

    public COSObject getLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("L"));
        if (object == null || object.empty()) {
            object = this.getLDefaultValue();
        }
        return object;
    }

    @Override
    public String getLType() {
        COSObject L = this.getLValue();
        return this.getObjectType(L);
    }

    @Override
    public Boolean getLHasTypeInteger() {
        COSObject L = this.getLValue();
        return GFAWebCaptureCommand.getHasTypeInteger(L);
    }

    @Override
    public Long getLIntegerValue() {
        COSObject L = this.getLValue();
        return GFAWebCaptureCommand.getIntegerValue(L);
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        return object;
    }

    @Override
    public Boolean getisPIndirect() {
        COSObject P = this.getPValue();
        return GFAWebCaptureCommand.getisIndirect(P);
    }

    @Override
    public String getPType() {
        COSObject P = this.getPValue();
        return this.getObjectType(P);
    }

    @Override
    public Boolean getPHasTypeStream() {
        COSObject P = this.getPValue();
        return GFAWebCaptureCommand.getHasTypeStream(P);
    }

    @Override
    public Boolean getPHasTypeString() {
        COSObject P = this.getPValue();
        return GFAWebCaptureCommand.getHasTypeString(P);
    }

    @Override
    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("S"));
        return object;
    }

    @Override
    public String getSType() {
        COSObject S = this.getSValue();
        return this.getObjectType(S);
    }

    @Override
    public Boolean getSHasTypeDictionary() {
        COSObject S = this.getSValue();
        return GFAWebCaptureCommand.getHasTypeDictionary(S);
    }

    @Override
    public Boolean getcontainsURL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("URL"));
    }

    public COSObject getURLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URL"));
        return object;
    }

    @Override
    public String getURLType() {
        COSObject URL2 = this.getURLValue();
        return this.getObjectType(URL2);
    }

    @Override
    public Boolean getURLHasTypeStringAscii() {
        COSObject URL2 = this.getURLValue();
        return GFAWebCaptureCommand.getHasTypeStringAscii(URL2);
    }
}

